/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.compat;

import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;

@SideOnly(value=Side.CLIENT)
public enum SeasonType {
    NONE("noseason"),
    SPRING("spring"),
    SUMMER("summer"),
    AUTUMN("autumn"),
    WINTER("winter");

    private final String val;

    private SeasonType(String val) {
        this.val = val;
    }

    @Nonnull
    public String getValue() {
        return this.val;
    }

    @Nonnull
    public static SeasonType getSeasonType(@Nonnull ISeasonState state) {
        if (state == null || state.getSeason() == null) {
            return NONE;
        }
        Season season = state.getSeason();
        switch (season) {
            case SUMMER: {
                return SUMMER;
            }
            case AUTUMN: {
                return AUTUMN;
            }
            case WINTER: {
                return WINTER;
            }
            case SPRING: {
                return SPRING;
            }
        }
        return NONE;
    }

    @Nonnull
    public static SubType getSeasonSubType(@Nonnull ISeasonState state) {
        Season.SubSeason sub = state.getSubSeason();
        switch (sub) {
            case EARLY_SUMMER: 
            case EARLY_AUTUMN: 
            case EARLY_WINTER: 
            case EARLY_SPRING: {
                return SubType.EARLY;
            }
            case MID_SUMMER: 
            case MID_AUTUMN: 
            case MID_WINTER: 
            case MID_SPRING: {
                return SubType.MID;
            }
            case LATE_SUMMER: 
            case LATE_AUTUMN: 
            case LATE_WINTER: 
            case LATE_SPRING: {
                return SubType.LATE;
            }
        }
        return SubType.NONE;
    }

    public static enum SubType {
        NONE("nosubtype"),
        EARLY("early"),
        MID("mid"),
        LATE("late");

        private final String val;

        private SubType(String val) {
            this.val = val;
        }

        @Nonnull
        public String getValue() {
            return this.val;
        }
    }
}

