/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.proxy;

import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import surreal.contentcreator.client.fluid.CustomFluidStateMapper;
import surreal.contentcreator.common.block.BlockBase;
import surreal.contentcreator.common.block.BlockMaterial;
import surreal.contentcreator.common.block.generic.BlockGenericColored;
import surreal.contentcreator.common.item.ItemBase;
import surreal.contentcreator.common.item.ItemBlockBase;
import surreal.contentcreator.common.item.ItemBlockMaterial;
import surreal.contentcreator.common.item.ItemMaterial;
import surreal.contentcreator.functions.item.IItemColorFunc;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.types.CTMaterial;
import surreal.contentcreator.util.CTUtil;
import surreal.contentcreator.util.FileGenUtil;
import surreal.contentcreator.util.IHaloItem;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final List<String> texturesToRegister = new ArrayList<String>();
    public static final List<ResourceLocation> fluidTextures = new ArrayList<ResourceLocation>();
    public static final IItemColor ITEMCOLOR = (stack, tintIndex) -> {
        if (stack.func_77973_b() instanceof ItemBase) {
            ItemBase item = (ItemBase)stack.func_77973_b();
            IItemColorFunc color = item.SUBITEMS.get((Object)Integer.valueOf((int)stack.func_77960_j())).COLOR;
            if (color != null) {
                return color.colorMultiplier(CraftTweakerMC.getIItemStack((ItemStack)stack), tintIndex);
            }
        }
        return 0xFFFFFF;
    };
    public static final IItemColor ITEMBLOCKCOLOR = (stack, index) -> {
        if (stack.func_77973_b() instanceof ItemBlockBase) {
            ItemBlockBase item = (ItemBlockBase)stack.func_77973_b();
            if (item.blockBase != null && item.blockBase.COLOR != null) {
                return item.blockBase.COLOR.colorMultiplier(CraftTweakerMC.getBlockState((IBlockState)item.blockBase.func_176203_a(stack.func_77960_j())), index);
            }
            if (item.func_179223_d() instanceof BlockGenericColored && ((BlockGenericColored)item.func_179223_d()).color) {
                return EnumDyeColor.func_176766_a((int)stack.func_77960_j()).func_193350_e();
            }
        }
        if (stack.func_77973_b() instanceof ItemBlockMaterial) {
            CTMaterial material = ((ItemBlockMaterial)stack.func_77973_b()).getMaterial(stack);
            return material.color;
        }
        return 0xFFFFFF;
    };
    public static final IItemColor MATERIALITEMCOLOR = (stack, tintIndex) -> {
        if (stack.func_77973_b() instanceof ItemMaterial) {
            ItemMaterial item = (ItemMaterial)stack.func_77973_b();
            return item.MATERIALS.get((Object)Integer.valueOf((int)stack.func_77960_j())).color;
        }
        return 0xFFFFFF;
    };
    public static final IBlockColor BLOCKCOLOR = (state, worldIn, pos, tintIndex) -> {
        if (state.func_177230_c() instanceof BlockBase) {
            BlockBase block = (BlockBase)state.func_177230_c();
            if (block.COLOR != null) {
                return block.COLOR.colorMultiplier(CraftTweakerMC.getBlockState((IBlockState)state), tintIndex);
            }
        } else if (state.func_177230_c() instanceof BlockGenericColored && ((BlockGenericColored)state.func_177230_c()).color) {
            return EnumDyeColor.func_176766_a((int)state.func_177230_c().func_176201_c(state)).func_193350_e();
        }
        return 0xFFFFFF;
    };
    public static final IBlockColor BLOCKMATERIALCOLOR = (state, worldIn, pos, tintIndex) -> {
        if (state.func_177230_c() instanceof BlockMaterial) {
            BlockMaterial block = (BlockMaterial)state.func_177230_c();
            return block.materials[block.func_176201_c((IBlockState)state)].color;
        }
        return 0xFFFFFF;
    };

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientProxy.registerHaloTextures();
    }

    private static void registerHaloTextures() {
        if (!Loader.isModLoaded((String)"avaritia")) {
            texturesToRegister.add(IHaloItem.getHaloTexture(0));
            texturesToRegister.add(IHaloItem.getHaloTexture(1));
            texturesToRegister.add(IHaloItem.getHaloTexture(2));
        }
    }

    private static void registerSprites(TextureMap map) {
        for (ResourceLocation resourceLocation : fluidTextures) {
            map.func_174942_a(resourceLocation);
        }
        for (String string : texturesToRegister) {
            map.func_174942_a(new ResourceLocation(string));
        }
    }

    private static void registerMappers() {
        for (Fluid fluid : CommonProxy.FLUIDS) {
            ClientProxy.registerFluidMapper(fluid);
        }
    }

    private static void registerFluidMapper(Fluid fluid) {
        if (fluid.getBlock() != null) {
            CustomFluidStateMapper mapper = new CustomFluidStateMapper(fluid.getName());
            ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)mapper);
        }
    }

    @SubscribeEvent
    public static void registerTextures(TextureStitchEvent.Pre event) {
        ClientProxy.registerSprites(event.getMap());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerMappers();
        for (ItemBase itemBase : CommonProxy.ITEMS) {
            for (int i : itemBase.SUBITEMS.keySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)itemBase, (int)i, (ModelResourceLocation)new ModelResourceLocation(itemBase.getModelLocation(i)));
            }
        }
        for (Item item : CommonProxy.ITEMBLOCKS) {
            for (int i = 0; i < CTUtil.getStacks(item).size(); ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }
        for (ItemMaterial itemMaterial : CommonProxy.MAT_ITEMS.values()) {
            for (CTMaterial material : itemMaterial.part.getMaterials()) {
                ModelLoader.setCustomModelResourceLocation((Item)itemMaterial, (int)material.id, (ModelResourceLocation)new ModelResourceLocation(itemMaterial.getModelLocation(material), "inventory"));
            }
        }
        if (Loader.isModLoaded((String)"resourceloader")) {
            FileGenUtil.generateFiles();
        }
    }

    @SubscribeEvent
    public static void regColorsBlock(ColorHandlerEvent.Block event) {
        for (Block block : CommonProxy.BLOCKS) {
            event.getBlockColors().func_186722_a(BLOCKCOLOR, new Block[]{block});
        }
        for (Block block : CommonProxy.MAT_BLOCKS) {
            event.getBlockColors().func_186722_a(BLOCKMATERIALCOLOR, new Block[]{block});
        }
    }

    @SubscribeEvent
    public static void regColorsItem(ColorHandlerEvent.Item event) {
        for (Item item : CommonProxy.ITEMS) {
            event.getItemColors().func_186730_a(ITEMCOLOR, new Item[]{item});
        }
        for (Item item : CommonProxy.ITEMBLOCKS) {
            event.getItemColors().func_186730_a(ITEMBLOCKCOLOR, new Item[]{item});
        }
        for (Item item : CommonProxy.MAT_ITEMS.values()) {
            event.getItemColors().func_186730_a(MATERIALITEMCOLOR, new Item[]{item});
        }
    }
}

