/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.item;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.functions.item.IItemApplyEnchantmentTableFunc;
import surreal.contentcreator.functions.item.IItemAttributeModifier;
import surreal.contentcreator.functions.item.IItemBlockBreakResetFunc;
import surreal.contentcreator.functions.item.IItemBlockDestroy;
import surreal.contentcreator.functions.item.IItemBlockStartBreakFunc;
import surreal.contentcreator.functions.item.IItemBooleanStackFunc;
import surreal.contentcreator.functions.item.IItemColorFunc;
import surreal.contentcreator.functions.item.IItemContainerItemFunc;
import surreal.contentcreator.functions.item.IItemContinueUsingFunc;
import surreal.contentcreator.functions.item.IItemCreatedFunc;
import surreal.contentcreator.functions.item.IItemCustomEntityFunc;
import surreal.contentcreator.functions.item.IItemDestroyCreative;
import surreal.contentcreator.functions.item.IItemDestroySpeedFunc;
import surreal.contentcreator.functions.item.IItemDisableShieldFunc;
import surreal.contentcreator.functions.item.IItemDoubleStackFunc;
import surreal.contentcreator.functions.item.IItemEffectHaloColor;
import surreal.contentcreator.functions.item.IItemEffectHaloSpread;
import surreal.contentcreator.functions.item.IItemEffectHaloTexture;
import surreal.contentcreator.functions.item.IItemEffectPulse;
import surreal.contentcreator.functions.item.IItemEntityItemUpdateFunc;
import surreal.contentcreator.functions.item.IItemEntityLifespanFunc;
import surreal.contentcreator.functions.item.IItemEntitySwingFunc;
import surreal.contentcreator.functions.item.IItemFloatStackFunc;
import surreal.contentcreator.functions.item.IItemHarvestBlockFunc;
import surreal.contentcreator.functions.item.IItemHighlightTip;
import surreal.contentcreator.functions.item.IItemHitEntityFunc;
import surreal.contentcreator.functions.item.IItemInformation;
import surreal.contentcreator.functions.item.IItemIntStackFunc;
import surreal.contentcreator.functions.item.IItemInteractionEntityFunc;
import surreal.contentcreator.functions.item.IItemLeftClickEntityFunc;
import surreal.contentcreator.functions.item.IItemPlayerDrop;
import surreal.contentcreator.functions.item.IItemPropertyFunc;
import surreal.contentcreator.functions.item.IItemReequipAnimation;
import surreal.contentcreator.functions.item.IItemRightClick;
import surreal.contentcreator.functions.item.IItemSetDamageFunc;
import surreal.contentcreator.functions.item.IItemStringStackFunc;
import surreal.contentcreator.functions.item.IItemUnlocalizedNameFunc;
import surreal.contentcreator.functions.item.IItemUseFinishFunc;
import surreal.contentcreator.functions.item.IItemUseFunc;
import surreal.contentcreator.functions.item.IItemUsingTickFunc;
import surreal.contentcreator.util.CTUtil;
import surreal.contentcreator.util.GeneralUtil;
import surreal.contentcreator.util.IHaloItem;

@ZenRegister
@ZenClass(value="contentcreator.item.SubItem")
public class SubItem {
    public IItemUnlocalizedNameFunc UNLOCNAME = null;
    public IItemUseFunc ITEMUSE = null;
    public IItemDestroySpeedFunc DESTROYSPEED = null;
    public IItemFloatStackFunc XPREPAIR = null;
    public IItemBlockStartBreakFunc BLOCKSTARTBREAK = null;
    public IItemUsingTickFunc USINGTICK = null;
    public IItemLeftClickEntityFunc LEFTCLICKENTITY = null;
    public IItemContainerItemFunc CONTAINERITEM = null;
    public IItemEntityLifespanFunc ENTITYLIFESPAN = null;
    public IItemCustomEntityFunc CUSTOMENTITY = null;
    public IItemEntityItemUpdateFunc ENTITYUPDATE = null;
    public IItemEntitySwingFunc ENTITYSWING = null;
    public IItemUseFunc ITEMUSEFIRST = null;
    public IItemUseFinishFunc ITEMUSEFINISH = null;
    public IItemIntStackFunc ITEMDAMAGE = null;
    public IItemBooleanStackFunc SHOWBAR = null;
    public IItemDoubleStackFunc DURABILITYDISPLAY = null;
    public IItemIntStackFunc COLORDISPLAY = null;
    public IItemIntStackFunc MAXDAMAGE = null;
    public IItemSetDamageFunc SETDAMAGE = null;
    public IItemDestroyCreative DESTROYCREATIVE = null;
    public IItemHarvestBlockFunc HARVESTBLOCK = null;
    public IItemIntStackFunc STACKLIMIT = null;
    public IItemReequipAnimation REEQUIP = null;
    public IItemBlockBreakResetFunc BREAKRESET = null;
    public IItemContinueUsingFunc CONTINUEUSING = null;
    public IItemStringStackFunc CREATORMODID = null;
    public IItemIntStackFunc ENCHANTABILITY = null;
    public IItemApplyEnchantmentTableFunc APPLYENCHTABLE = null;
    public IItemBooleanStackFunc BEACONPAYMENT = null;
    public IItemCreatedFunc CREATED = null;
    public IItemIntStackFunc BURNTIME = null;
    public IItemDisableShieldFunc DISABLESHIED = null;
    public IItemStringStackFunc RARITY = null;
    public IItemBooleanStackFunc EFFECT = null;
    public IItemStringStackFunc ACTION = null;
    public IItemIntStackFunc MAXUSEDURATION = null;
    public IItemRightClick RIGHTCLICK = null;
    public IItemHitEntityFunc ENTITYHIT = null;
    public IItemInteractionEntityFunc ENTITYINTERACTION = null;
    public IItemColorFunc COLOR = null;
    public IItemInformation INFO = null;
    public IItemBlockDestroy DESTROYBLOCK = null;
    public IItemHighlightTip HIGHLIGHTTIP = null;
    public IItemPlayerDrop PLAYERDROP = null;
    public IItemAttributeModifier ATTACKDAMAGE = null;
    public IItemAttributeModifier ATTACKSPEED = null;
    public IItemIntStackFunc HEALAMOUNT = null;
    public IItemFloatStackFunc SATURATION = null;
    public IItemBooleanStackFunc WOLFSFAVORITE = null;
    public IItemBooleanStackFunc ALWAYSEDIBLE = null;
    public IItemEffectHaloTexture HALOTEXTURE = null;
    public IItemEffectHaloColor HALOCOLOR = null;
    public IItemEffectHaloSpread HALOSPREAD = null;
    public IItemEffectPulse PULSE = null;
    public final int meta;
    public Map<ResourceLocation, IItemPropertyFunc> itemProperties = null;
    public Map<String, Integer> toolClasses = null;
    public List<String> oreList = null;

    public SubItem(int meta) {
        this.meta = meta;
    }

    @ZenMethod
    public SubItem addProperty(String name, IItemPropertyFunc func) {
        if (this.itemProperties == null) {
            this.itemProperties = new Object2ObjectOpenHashMap();
        }
        this.itemProperties.put(new ResourceLocation("contentcreator", name), func);
        return this;
    }

    @ZenMethod
    public SubItem setUnlocalizedName(IItemUnlocalizedNameFunc func) {
        this.UNLOCNAME = func;
        return this;
    }

    @ZenMethod
    public SubItem setUnlocalizedName(String unlocName) {
        this.UNLOCNAME = stack -> unlocName;
        return this;
    }

    @ZenMethod
    public SubItem setItemUse(IItemUseFunc func) {
        this.ITEMUSE = func;
        return this;
    }

    @ZenMethod
    public SubItem setDestroySpeed(IItemDestroySpeedFunc func) {
        this.DESTROYSPEED = func;
        return this;
    }

    @ZenMethod
    public SubItem setDestroySpeed(float value) {
        this.DESTROYSPEED = (stack, state) -> value;
        return this;
    }

    @ZenMethod
    public SubItem setXpRepair(IItemFloatStackFunc func) {
        this.XPREPAIR = func;
        return this;
    }

    @ZenMethod
    public SubItem setXpRepair(float ratio) {
        this.XPREPAIR = stack -> ratio;
        return this;
    }

    @ZenMethod
    public SubItem setBlockStartBreak(IItemBlockStartBreakFunc func) {
        this.BLOCKSTARTBREAK = func;
        return this;
    }

    @ZenMethod
    public SubItem setUsingTick(IItemUsingTickFunc func) {
        this.USINGTICK = func;
        return this;
    }

    @ZenMethod
    public SubItem setLeftClickEntity(IItemLeftClickEntityFunc func) {
        this.LEFTCLICKENTITY = func;
        return this;
    }

    @ZenMethod
    public SubItem setContainerItem(IItemContainerItemFunc func) {
        this.CONTAINERITEM = func;
        return this;
    }

    @ZenMethod
    public SubItem setContainerItem(IItemStack stack) {
        this.CONTAINERITEM = stack1 -> stack;
        return this;
    }

    @ZenMethod
    public SubItem setContainerItem(String stack) {
        this.CONTAINERITEM = stack1 -> CraftTweakerMC.getIItemStack((ItemStack)GeneralUtil.getStackFromString(stack));
        return this;
    }

    @ZenMethod
    public SubItem setEntityLifespan(IItemEntityLifespanFunc func) {
        this.ENTITYLIFESPAN = func;
        return this;
    }

    @ZenMethod
    public SubItem setEntityLifespan(int time) {
        this.ENTITYLIFESPAN = (stack, world) -> time;
        return this;
    }

    @ZenMethod
    public SubItem setCustomEntity(IItemCustomEntityFunc func) {
        this.CUSTOMENTITY = func;
        return this;
    }

    @ZenMethod
    public SubItem setEntityItemUpdate(IItemEntityItemUpdateFunc func) {
        this.ENTITYUPDATE = func;
        return this;
    }

    @ZenMethod
    public SubItem setEntitySwing(IItemEntitySwingFunc func) {
        this.ENTITYSWING = func;
        return this;
    }

    @ZenMethod
    public SubItem setItemDamageGetter(IItemIntStackFunc func) {
        this.ITEMDAMAGE = func;
        return this;
    }

    @ZenMethod
    public SubItem shouldShowDurabilityBar(IItemBooleanStackFunc func) {
        this.SHOWBAR = func;
        return this;
    }

    @ZenMethod
    public SubItem setDurabilityDisplay(IItemDoubleStackFunc func) {
        this.DURABILITYDISPLAY = func;
        return this;
    }

    @ZenMethod
    public SubItem setDurabilityColor(IItemIntStackFunc func) {
        this.COLORDISPLAY = func;
        return this;
    }

    @ZenMethod
    public SubItem setMaxDamageGetter(IItemIntStackFunc func) {
        this.MAXDAMAGE = func;
        return this;
    }

    @ZenMethod
    public SubItem setDamageSetter(IItemSetDamageFunc func) {
        this.SETDAMAGE = func;
        return this;
    }

    @ZenMethod
    public SubItem setTool(String tool, int level, int maxDamage, float efficiency, @Optional int enchantability, @Optional double attackDamage, @Optional double attackSpeed) {
        this.MAXDAMAGE = stack -> maxDamage;
        this.ITEMDAMAGE = stack -> {
            ItemStack internal = (ItemStack)stack.getInternal();
            NBTTagCompound tag = internal.func_77978_p();
            if (tag != null) {
                return tag.func_74762_e("Damage");
            }
            internal.func_77982_d(new NBTTagCompound());
            return 0;
        };
        this.SETDAMAGE = (stack, damageToSet) -> {
            ItemStack internal = (ItemStack)stack.getInternal();
            NBTTagCompound tag = internal.func_77978_p();
            if (tag != null) {
                tag.func_74768_a("Damage", damageToSet);
            } else {
                internal.func_77982_d(new NBTTagCompound());
            }
        };
        this.DESTROYBLOCK = (world, stack, state, pos, entity) -> {
            if (!world.isRemote() && (double)state.getBlockHardness(world, pos) != 0.0) {
                stack.damageItem(1, (IEntity)entity);
            }
            return true;
        };
        this.ENTITYHIT = (stack, entity, attacker) -> {
            stack.damageItem(2, (IEntity)attacker);
            return true;
        };
        this.DESTROYSPEED = (stack, state) -> {
            for (String classes : stack.getToolClasses()) {
                if (!state.getBlock().getDefinition().isToolEffective(classes, state)) continue;
                return efficiency;
            }
            return 1.0f;
        };
        this.HARVESTBLOCK = (state, stack) -> {
            net.minecraft.block.state.IBlockState st = (net.minecraft.block.state.IBlockState)state.getInternal();
            Block block = st.func_177230_c();
            if (tool.equalsIgnoreCase("shovel")) {
                return block instanceof BlockSnow || block instanceof BlockSnowBlock;
            }
            return st.func_177230_c().getHarvestTool(st) == null || st.func_177230_c().getHarvestLevel(st) <= level && st.func_177230_c().getHarvestTool(st).equalsIgnoreCase(tool);
        };
        this.ITEMUSE = (pl, world, position, hand, face, hitX, hitY, hitZ) -> {
            EntityPlayer player = (EntityPlayer)pl.getInternal();
            ItemStack itemstack = player.func_184586_b(CTUtil.getHand(hand));
            BlockPos pos = (BlockPos)position.getInternal();
            EnumFacing facing = (EnumFacing)face.getInternal();
            World worldIn = (World)world.getInternal();
            if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
                return "FAIL";
            }
            net.minecraft.block.state.IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (facing != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a())) {
                if (tool.equalsIgnoreCase("shovel") && block == Blocks.field_150349_c) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 11);
                    }
                    return "SUCCESS";
                }
                if (tool.equalsIgnoreCase("hoe") && block == Blocks.field_150349_c || block == Blocks.field_185774_da || block == Blocks.field_150346_d) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!worldIn.field_72995_K) {
                        if (block.func_176201_c(iblockstate) != 1) {
                            worldIn.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 11);
                        } else {
                            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 11);
                        }
                    }
                    return "SUCCESS";
                }
            }
            return "PASS";
        };
        this.REEQUIP = (oldStack, newStack, slotChanged) -> {
            ItemStack stack = (ItemStack)oldStack.getInternal();
            ItemStack stack1 = (ItemStack)newStack.getInternal();
            return stack.func_77973_b() != stack1.func_77973_b() || stack.func_77960_j() != stack1.func_77960_j();
        };
        return this.addToolClass(tool, level).setAttackDamage(attackDamage).setAttackSpeed(attackSpeed).setEnchantability(enchantability);
    }

    @ZenMethod
    public SubItem setWeapon(int maxDamage, double attackDamage, @Optional double attackSpeed, @Optional int enchantability) {
        if (attackSpeed == 0.0) {
            attackSpeed = -2.4f;
        }
        this.ENTITYHIT = (stack, entity, attacker) -> {
            stack.damageItem(1, (IEntity)attacker);
            return true;
        };
        this.DESTROYBLOCK = (world, stack, state, pos, entity) -> {
            if (!world.isRemote() && (double)state.getBlockHardness(world, pos) != 0.0) {
                stack.damageItem(2, (IEntity)entity);
            }
            return true;
        };
        this.DESTROYSPEED = (stack, st) -> {
            net.minecraft.block.state.IBlockState state = (net.minecraft.block.state.IBlockState)st.getInternal();
            Block block = state.func_177230_c();
            if (block instanceof BlockWeb) {
                return 15.0f;
            }
            Material material = state.func_185904_a();
            return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
        };
        this.DESTROYCREATIVE = (world, pos, stack, player) -> false;
        return this.setAttackDamage(attackDamage).setAttackSpeed(attackSpeed).setEnchantability(enchantability);
    }

    @ZenMethod
    public SubItem setAttackDamage(IItemAttributeModifier func) {
        this.ATTACKDAMAGE = func;
        return this;
    }

    @ZenMethod
    public SubItem setAttackSpeed(IItemAttributeModifier func) {
        this.ATTACKSPEED = func;
        return this;
    }

    @ZenMethod
    public SubItem setAttackDamage(double value) {
        if (value > 0.0) {
            this.ATTACKDAMAGE = slot -> {
                EntityEquipmentSlot equipmentSlot = (EntityEquipmentSlot)slot.getInternal();
                if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
                    return value;
                }
                return 0.0;
            };
        }
        return this;
    }

    @ZenMethod
    public SubItem setAttackSpeed(double value) {
        if (value > 0.0) {
            this.ATTACKSPEED = slot -> {
                EntityEquipmentSlot equipmentSlot = (EntityEquipmentSlot)slot.getInternal();
                if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
                    return value;
                }
                return 0.0;
            };
        }
        return this;
    }

    @ZenMethod
    public SubItem canDestroyInCreative(IItemDestroyCreative func) {
        this.DESTROYCREATIVE = func;
        return this;
    }

    @ZenMethod
    public SubItem disableCreativeBlockDestroy() {
        this.DESTROYCREATIVE = (world, pos, stack, player) -> false;
        return this;
    }

    @ZenMethod
    public SubItem canHarvestBlock(IItemHarvestBlockFunc func) {
        this.HARVESTBLOCK = func;
        return this;
    }

    @ZenMethod
    public SubItem setMaxStackSize(IItemIntStackFunc func) {
        this.STACKLIMIT = func;
        return this;
    }

    @ZenMethod
    public SubItem setMaxStackSize(int value) {
        this.STACKLIMIT = stack -> value;
        return this;
    }

    @ZenMethod
    public SubItem addToolClass(String tool, int level) {
        if (this.toolClasses == null) {
            this.toolClasses = new Object2ObjectOpenHashMap();
        }
        this.toolClasses.put(tool, level);
        return this;
    }

    @ZenMethod
    public SubItem causeReequipAnimation(IItemReequipAnimation func) {
        this.REEQUIP = func;
        return this;
    }

    @ZenMethod
    public SubItem causeBlockBreakReset(IItemBlockBreakResetFunc func) {
        this.BREAKRESET = func;
        return this;
    }

    @ZenMethod
    public SubItem continueUsing(IItemContinueUsingFunc func) {
        this.CONTINUEUSING = func;
        return this;
    }

    @ZenMethod
    public SubItem setContinueUsing() {
        this.CONTINUEUSING = (oldStack, newStack) -> true;
        return this;
    }

    @ZenMethod
    public SubItem setCreatorModId(IItemStringStackFunc func) {
        this.CREATORMODID = func;
        return this;
    }

    @ZenMethod
    public SubItem setEnchantability(IItemIntStackFunc func) {
        this.ENCHANTABILITY = func;
        return this;
    }

    @ZenMethod
    public SubItem setEnchantability(int value) {
        this.ENCHANTABILITY = stack -> value;
        return this;
    }

    @ZenMethod
    public SubItem canApplyEnchantment(IItemApplyEnchantmentTableFunc func) {
        this.APPLYENCHTABLE = func;
        return this;
    }

    @ZenMethod
    public SubItem setBeaconPayment(IItemBooleanStackFunc func) {
        this.BEACONPAYMENT = func;
        return this;
    }

    @ZenMethod
    public SubItem setBeaconPayment() {
        this.BEACONPAYMENT = stack -> true;
        return this;
    }

    @ZenMethod
    public SubItem setItemUseFirst(IItemUseFunc func) {
        this.ITEMUSEFIRST = func;
        return this;
    }

    @ZenMethod
    public SubItem setItemCreated(IItemCreatedFunc func) {
        this.CREATED = func;
        return this;
    }

    @ZenMethod
    public SubItem setBurnTime(IItemIntStackFunc func) {
        this.BURNTIME = func;
        return this;
    }

    @ZenMethod
    public SubItem setBurnTime(int value) {
        this.BURNTIME = stack -> value;
        return this;
    }

    @ZenMethod
    public SubItem canDisableShield(IItemDisableShieldFunc func) {
        this.DISABLESHIED = func;
        return this;
    }

    @ZenMethod
    public SubItem canDisableShield() {
        this.DISABLESHIED = (stack, shield, entity, attacker) -> true;
        return this;
    }

    @ZenMethod
    public SubItem setTooltip(IItemInformation func) {
        this.INFO = func;
        return this;
    }

    @ZenMethod
    public SubItem setTooltip(String ... string) {
        this.INFO = (stack, world, isAdvanced) -> string;
        return this;
    }

    @ZenMethod
    public SubItem setOres(String ... ores) {
        if (this.oreList == null) {
            this.oreList = new ArrayList<String>();
        }
        Collections.addAll(this.oreList, ores);
        return this;
    }

    @ZenMethod
    public SubItem setRarity(IItemStringStackFunc func) {
        this.RARITY = func;
        return this;
    }

    @ZenMethod
    public SubItem setRarity(String name) {
        this.RARITY = stack -> name;
        return this;
    }

    @ZenMethod
    public SubItem setEffect(IItemBooleanStackFunc func) {
        this.EFFECT = func;
        return this;
    }

    @ZenMethod
    public SubItem setEffect() {
        this.EFFECT = stack -> true;
        return this;
    }

    @ZenMethod
    public SubItem setUseAction(IItemStringStackFunc func) {
        this.ACTION = func;
        return this;
    }

    @ZenMethod
    public SubItem setUseAction(String value) {
        this.ACTION = stack -> value;
        return this;
    }

    @ZenMethod
    public SubItem setMaxUseDuration(IItemIntStackFunc func) {
        this.MAXUSEDURATION = func;
        return this;
    }

    @ZenMethod
    public SubItem setMaxUseDuration(int value) {
        this.MAXUSEDURATION = stack -> value;
        return this;
    }

    @ZenMethod
    public SubItem setRightClick(IItemRightClick func) {
        this.RIGHTCLICK = func;
        return this;
    }

    @ZenMethod
    public SubItem setHealAmount(IItemIntStackFunc func) {
        this.HEALAMOUNT = func;
        return this;
    }

    @ZenMethod
    public SubItem setHealAmount(int amount) {
        this.HEALAMOUNT = stack -> amount;
        return this;
    }

    @ZenMethod
    public SubItem setSaturation(IItemFloatStackFunc func) {
        this.SATURATION = func;
        return this;
    }

    @ZenMethod
    public SubItem setSaturation(float amount) {
        this.SATURATION = stack -> amount;
        return this;
    }

    @ZenMethod
    public SubItem setWolfsFavorite(IItemBooleanStackFunc func) {
        this.WOLFSFAVORITE = func;
        return this;
    }

    @ZenMethod
    public SubItem setWolfsFavorite() {
        this.WOLFSFAVORITE = stack -> true;
        return this;
    }

    @ZenMethod
    public SubItem setAlwaysEdible(IItemBooleanStackFunc func) {
        this.ALWAYSEDIBLE = func;
        return this;
    }

    @ZenMethod
    public SubItem setAlwaysEdible() {
        this.ALWAYSEDIBLE = stack -> true;
        return this;
    }

    @ZenMethod
    public SubItem setUseFinish(IItemUseFinishFunc func) {
        this.ITEMUSEFINISH = func;
        return this;
    }

    @ZenMethod
    public SubItem setEntityHit(IItemHitEntityFunc func) {
        this.ENTITYHIT = func;
        return this;
    }

    @ZenMethod
    public SubItem setEntityInteract(IItemInteractionEntityFunc func) {
        this.ENTITYINTERACTION = func;
        return this;
    }

    @ZenMethod
    public SubItem setColor(IItemColorFunc func) {
        this.COLOR = func;
        return this;
    }

    @ZenMethod
    public SubItem setBlockDestroyed(IItemBlockDestroy func) {
        this.DESTROYBLOCK = func;
        return this;
    }

    @ZenMethod
    public SubItem setHighlightTip(IItemHighlightTip func) {
        this.HIGHLIGHTTIP = func;
        return this;
    }

    @ZenMethod
    public SubItem setPlayerDropped(IItemPlayerDrop func) {
        this.PLAYERDROP = func;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundTexture(IItemEffectHaloTexture func) {
        this.HALOTEXTURE = func;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundTexture(String texture) {
        this.HALOTEXTURE = (world, player, stack) -> texture;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundTexture(int halo) {
        this.HALOTEXTURE = (world, player, stack) -> IHaloItem.getHaloTexture(halo);
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundSize(IItemEffectHaloSpread func) {
        this.HALOSPREAD = func;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundSize(int size) {
        this.HALOSPREAD = (world, player, stack) -> size;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundColor(IItemEffectHaloColor func) {
        this.HALOCOLOR = func;
        return this;
    }

    @ZenMethod
    public SubItem setBackgroundColor(int color) {
        this.HALOCOLOR = (world, player, stack) -> color;
        return this;
    }

    @ZenMethod
    public SubItem setPulseEffect(IItemEffectPulse func) {
        this.PULSE = func;
        return this;
    }

    @ZenMethod
    public SubItem setPulseEffect() {
        this.PULSE = (world, player, stack) -> true;
        return this;
    }

    @ZenMethod
    public SubItem setBlock(IBlockState state) {
        this.ITEMUSE = (iplayer, world, ipos, hand, ifacing, hitX, hitY, hitZ) -> {
            ItemStack itemstack;
            World worldIn = CraftTweakerMC.getWorld((IWorld)world);
            BlockPos pos = CraftTweakerMC.getBlockPos((IBlockPos)ipos);
            EnumFacing facing = CraftTweakerMC.getFacing((IFacing)ifacing);
            EntityPlayer player = CraftTweakerMC.getPlayer((IPlayer)iplayer);
            net.minecraft.block.state.IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!(itemstack = player.func_184586_b(CraftTweakerMC.getHand((IEntityEquipmentSlot)hand))).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(CraftTweakerMC.getBlockState((IBlockState)state).func_177230_c(), pos, false, facing, (Entity)player)) {
                int i = state.getMeta();
                net.minecraft.block.state.IBlockState iblockstate1 = CraftTweakerMC.getBlockState((IBlockState)state).func_177230_c().getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, CraftTweakerMC.getHand((IEntityEquipmentSlot)hand));
                if (this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                    iblockstate1 = worldIn.func_180495_p(pos);
                    SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return "SUCCESS";
            }
            return "FAIL";
        };
        return this;
    }

    private boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, net.minecraft.block.state.IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        net.minecraft.block.state.IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == newState.func_177230_c()) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            newState.func_177230_c().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }
}

