/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.item;

import com.google.common.collect.Maps;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import surreal.contentcreator.types.CTMaterial;
import surreal.contentcreator.types.parts.PartItem;
import surreal.contentcreator.util.GeneralUtil;
import surreal.contentcreator.util.IHaloItem;

public class ItemMaterial
extends Item
implements IHaloItem {
    public PartItem part;
    public Map<Integer, CTMaterial> MATERIALS;

    public ItemMaterial(PartItem type) {
        this.part = type;
        this.MATERIALS = Maps.newHashMap();
        for (CTMaterial material : type.materials) {
            this.MATERIALS.put(material.id, material);
        }
        this.setRegistryName("contentcreator", type.name);
        this.func_77655_b("contentcreator." + type.name);
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78027_g);
    }

    @Nonnull
    public String func_77653_i(ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        if (material != null) {
            return I18n.func_135052_a((String)("part." + this.part.name), (Object[])new Object[]{material.getLocalizedName()});
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (CTMaterial material : this.part.materials) {
                items.add((Object)new ItemStack((Item)this, 1, material.id));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        if (material.tooltips != null) {
            tooltip.addAll(material.tooltips);
        }
    }

    @Nonnull
    public IRarity getForgeRarity(ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return EnumRarity.valueOf((String)material.rarity.toUpperCase());
    }

    public String getModelLocation(CTMaterial material) {
        return "contentcreator:part/" + material.textureType + "/" + this.part.name;
    }

    @Override
    public ResourceLocation getLocation(World world, EntityPlayer player, ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return material.HALOTEXTURE != null ? GeneralUtil.getTextureLocation(material.HALOTEXTURE.getTexture(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack))) : null;
    }

    @Override
    public int getSpread(World world, EntityPlayer player, ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return material.HALOSPREAD != null ? material.HALOSPREAD.getSpread(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack)) : 1;
    }

    @Override
    public int getColor(World world, EntityPlayer player, ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return material.HALOCOLOR != null ? material.HALOCOLOR.getColor(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack)) : -16777216;
    }

    @Override
    public boolean shouldPulse(World world, EntityPlayer player, ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return material.EFFECTPULSE != null && material.EFFECTPULSE.shouldPulse(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack));
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        CTMaterial material = this.MATERIALS.get(stack.func_77960_j());
        return material.enchantedEffect;
    }
}

