/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.item;

import com.google.common.collect.Multimap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.common.item.SubItem;
import surreal.contentcreator.functions.item.IItemPropertyFunc;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.util.CTUtil;
import surreal.contentcreator.util.GeneralUtil;
import surreal.contentcreator.util.IHaloItem;

@ZenRegister
@ZenClass(value="contentcreator.item.Item")
@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="applecore")
public class ItemBase
extends Item
implements IEdible,
IHaloItem {
    public final Map<Integer, SubItem> SUBITEMS = new Int2ObjectOpenHashMap();
    public boolean modelBlockState = false;

    public ItemBase() {
        this.func_77637_a(CreativeTabs.field_78027_g);
        this.func_77655_b("");
    }

    @ZenMethod
    public static ItemBase create(String name) {
        return (ItemBase)((Item)new ItemBase().setRegistryName("contentcreator", name)).func_77655_b("contentcreator." + name);
    }

    @ZenMethod
    public static ItemBase getItem(String name) {
        for (ItemBase item : CommonProxy.ITEMS) {
            if (!item.getRegistryName().toString().equals(name)) continue;
            return item;
        }
        return null;
    }

    @ZenMethod
    public static ItemBase getItem(IItemStack st) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)st);
        if (stack.func_77973_b() instanceof ItemBase) {
            return (ItemBase)stack.func_77973_b();
        }
        return null;
    }

    @ZenMethod
    public static ItemBase getItem(IItemDefinition definition) {
        Item item = CraftTweakerMC.getItem((IItemDefinition)definition);
        if (item instanceof ItemBase) {
            return (ItemBase)item;
        }
        return null;
    }

    @ZenMethod
    public static SubItem getSubItem(String name, int meta) {
        ItemBase item = ItemBase.getItem(name);
        return item != null ? item.getItem(meta) : null;
    }

    @ZenMethod
    public ItemBase add(SubItem ... items) {
        for (SubItem sub : items) {
            this.SUBITEMS.put(sub.meta, sub);
        }
        return this;
    }

    @ZenMethod
    public ItemBase setModelVariant() {
        this.modelBlockState = true;
        return this;
    }

    @ZenMethod
    public SubItem getItem(int meta) {
        if (meta < 0) {
            return null;
        }
        SubItem sub = this.SUBITEMS.get(meta);
        if (sub != null) {
            return sub;
        }
        return ItemBase.sub(meta);
    }

    @ZenMethod
    public boolean hasItem(int meta) {
        return meta >= 0 && this.SUBITEMS.containsKey(meta);
    }

    @ZenMethod
    public static SubItem sub(int meta) {
        return new SubItem(meta);
    }

    @ZenMethod
    public static SubItem sub() {
        return new SubItem(0);
    }

    @ZenMethod
    public void register() {
        if (this.SUBITEMS.size() == 0) {
            this.SUBITEMS.put(0, new SubItem(0));
        } else {
            for (SubItem subItem : this.SUBITEMS.values()) {
                Map<ResourceLocation, IItemPropertyFunc> props = subItem.itemProperties;
                Map<String, Integer> classes = subItem.toolClasses;
                if (props != null) {
                    props.forEach((key, value) -> this.func_185043_a((ResourceLocation)key, (stack, worldIn, entityIn) -> value.apply(CraftTweakerMC.getIItemStack((ItemStack)stack), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entityIn))));
                }
                if (classes == null) continue;
                classes.forEach((arg_0, arg_1) -> ((ItemBase)this).setHarvestLevel(arg_0, arg_1));
            }
        }
        this.func_77627_a(this.SUBITEMS.size() > 1);
        CommonProxy.ITEMS.add(this);
    }

    private SubItem get(ItemStack stack) {
        return this.SUBITEMS.get(stack.func_77960_j());
    }

    public String getModelLocation(int meta) {
        SubItem subItem = this.SUBITEMS.get(meta);
        String model = !this.modelBlockState ? this.getRegistryName().func_110624_b() + ":" : this.getRegistryName().func_110624_b() + ":item/" + this.getRegistryName().func_110623_a();
        String variant = this.getRegistryName().func_110623_a() + "." + meta;
        if (subItem != null && subItem.UNLOCNAME != null) {
            variant = subItem.UNLOCNAME.getUnlocalizedName(CraftTweakerMC.getIItemStack((ItemStack)new ItemStack((Item)this, 1, meta)));
        }
        model = model + (this.modelBlockState ? "#type=" + variant : variant + "#inventory");
        return model;
    }

    public String getSubName(SubItem subItem) {
        return subItem.UNLOCNAME != null ? subItem.UNLOCNAME.getUnlocalizedName(CraftTweakerMC.getIItemStack((ItemStack)new ItemStack((Item)this, 1, subItem.meta))) : null;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i : this.SUBITEMS.keySet()) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        return subItem != null && subItem.UNLOCNAME != null ? "item.contentcreator." + subItem.UNLOCNAME.getUnlocalizedName(CraftTweakerMC.getIItemStack((ItemStack)stack)) : this.func_77658_a() + (this.SUBITEMS.size() > 1 ? "." + stack.func_77960_j() : "");
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ITEMUSE != null) {
            return EnumActionResult.valueOf((String)subItem.ITEMUSE.onItemUse(CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CTUtil.getHandEquipment(hand), CraftTweakerMC.getIFacing((EnumFacing)facing), hitX, hitY, hitZ).toUpperCase());
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.DESTROYSPEED != null) {
            return subItem.DESTROYSPEED.getDestroySpeed(CraftTweakerMC.getIItemStack((ItemStack)stack), CraftTweakerMC.getBlockState((IBlockState)state));
        }
        return super.func_150893_a(stack, state);
    }

    public float getXpRepairRatio(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.XPREPAIR != null) {
            return subItem.XPREPAIR.getFloat(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getXpRepairRatio(stack);
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        SubItem subItem = this.get(itemstack);
        if (subItem != null && subItem.BLOCKSTARTBREAK != null) {
            return subItem.BLOCKSTARTBREAK.onBlockStartBreak(CraftTweakerMC.getIItemStackMutable((ItemStack)itemstack), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIPlayer((EntityPlayer)player));
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public void onUsingTick(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player, int count) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.USINGTICK != null) {
            subItem.USINGTICK.onUsingTick(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)player), count);
        } else {
            super.onUsingTick(stack, player, count);
        }
    }

    public boolean onLeftClickEntity(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.LEFTCLICKENTITY != null) {
            return subItem.LEFTCLICKENTITY.onLeftClickEntity(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIEntity((Entity)entity));
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        SubItem subItem = this.get(itemStack);
        if (subItem != null && subItem.CONTAINERITEM != null) {
            return CraftTweakerMC.getItemStack((IItemStack)subItem.CONTAINERITEM.getContainerItem(CraftTweakerMC.getIItemStack((ItemStack)itemStack)));
        }
        return super.getContainerItem(itemStack);
    }

    public int getEntityLifespan(@Nonnull ItemStack itemStack, @Nonnull World world) {
        SubItem subItem = this.get(itemStack);
        if (subItem != null && subItem.ENTITYLIFESPAN != null) {
            return subItem.ENTITYLIFESPAN.getEntityLifespane(CraftTweakerMC.getIItemStack((ItemStack)itemStack), CraftTweakerMC.getIWorld((World)world));
        }
        return super.getEntityLifespan(itemStack, world);
    }

    public int getItemEnchantability(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ENCHANTABILITY != null) {
            return subItem.ENCHANTABILITY.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getItemEnchantability(stack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.APPLYENCHTABLE != null) {
            return subItem.APPLYENCHTABLE.canApplyAtEnchantingTable(CraftTweakerMC.getIItemStack((ItemStack)stack), CTUtil.getEnchantment(enchantment));
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Nullable
    public Entity createEntity(@Nonnull World world, @Nonnull Entity location, @Nonnull ItemStack itemstack) {
        SubItem subItem = this.get(itemstack);
        if (subItem != null && subItem.CUSTOMENTITY != null) {
            return CraftTweakerMC.getEntity((IEntity)subItem.CUSTOMENTITY.createEntity(CraftTweakerMC.getIWorld((World)world), (IEntityItem)CraftTweakerMC.getIEntity((Entity)location), CraftTweakerMC.getIItemStack((ItemStack)itemstack)));
        }
        return super.createEntity(world, location, itemstack);
    }

    public boolean hasCustomEntity(@Nonnull ItemStack stack) {
        return this.get((ItemStack)stack).CUSTOMENTITY != null;
    }

    public boolean onEntityItemUpdate(@Nonnull EntityItem entityItem) {
        SubItem subItem = this.get(entityItem.func_92059_d());
        if (subItem != null && subItem.ENTITYUPDATE != null) {
            return subItem.ENTITYUPDATE.onEntityItemUpdate((IEntityItem)new CTUtil.MCEntityItemMutable(entityItem));
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public boolean onEntitySwing(@Nonnull EntityLivingBase entityLiving, @Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ENTITYSWING != null) {
            return subItem.ENTITYSWING.onEntitySwing(CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entityLiving), CraftTweakerMC.getIItemStackMutable((ItemStack)stack));
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public int getDamage(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ITEMDAMAGE != null) {
            return subItem.ITEMDAMAGE.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getDamage(stack);
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.SHOWBAR != null) {
            return subItem.SHOWBAR.getBool(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.DURABILITYDISPLAY != null) {
            return subItem.DURABILITYDISPLAY.getDouble(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.COLORDISPLAY != null) {
            return subItem.COLORDISPLAY.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.MAXDAMAGE != null) {
            return subItem.MAXDAMAGE.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getMaxDamage(stack);
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.SETDAMAGE != null) {
            subItem.SETDAMAGE.setDamage(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), damage);
        } else {
            super.setDamage(stack, damage);
        }
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.DESTROYCREATIVE != null) {
            return subItem.DESTROYCREATIVE.canDestroyBlockInCreative(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIItemStack((ItemStack)stack), CraftTweakerMC.getIPlayer((EntityPlayer)player));
        }
        return super.canDestroyBlockInCreative(world, pos, stack, player);
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, @Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.HARVESTBLOCK != null) {
            return subItem.HARVESTBLOCK.canHarvestBlock(CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.canHarvestBlock(state, stack);
    }

    public int getItemStackLimit(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.STACKLIMIT != null) {
            return subItem.STACKLIMIT.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.getItemStackLimit(stack);
    }

    public boolean isBeaconPayment(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.BEACONPAYMENT != null) {
            return subItem.BEACONPAYMENT.getBool(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.isBeaconPayment(stack);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        SubItem subItem = this.get(oldStack);
        if (subItem != null && subItem.REEQUIP != null) {
            return subItem.REEQUIP.shouldCauseReequipAnimation(CraftTweakerMC.getIItemStack((ItemStack)oldStack), CraftTweakerMC.getIItemStack((ItemStack)newStack), slotChanged);
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        SubItem subItem = this.get(oldStack);
        if (subItem != null && subItem.BREAKRESET != null) {
            return subItem.BREAKRESET.shouldCauseBlockBreakReset(CraftTweakerMC.getIItemStack((ItemStack)oldStack), CraftTweakerMC.getIItemStack((ItemStack)newStack));
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean canContinueUsing(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        SubItem subItem = this.get(oldStack);
        if (subItem != null && subItem.CONTINUEUSING != null) {
            return subItem.CONTINUEUSING.canContinueUsing(CraftTweakerMC.getIItemStack((ItemStack)oldStack), CraftTweakerMC.getIItemStack((ItemStack)newStack));
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    @Nullable
    public String getCreatorModId(@Nonnull ItemStack itemStack) {
        SubItem subItem = this.get(itemStack);
        if (subItem != null && subItem.CREATORMODID != null) {
            CraftTweakerAPI.logWarning((String)"You cannot change mod id!");
        }
        return super.getCreatorModId(itemStack);
    }

    public boolean canDisableShield(@Nonnull ItemStack stack, @Nonnull ItemStack shield, @Nonnull EntityLivingBase entity, @Nonnull EntityLivingBase attacker) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.DISABLESHIED != null) {
            return subItem.DISABLESHIED.canDisableShield(CraftTweakerMC.getIItemStack((ItemStack)stack), CraftTweakerMC.getIItemStack((ItemStack)shield), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entity), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)attacker));
        }
        return super.canDisableShield(stack, shield, entity, attacker);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.INFO != null) {
            Collections.addAll(tooltip, subItem.INFO.addInformation(CraftTweakerMC.getIItemStack((ItemStack)stack), CraftTweakerMC.getIWorld((World)worldIn), flagIn.func_194127_a()));
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    public int getItemBurnTime(@Nonnull ItemStack itemStack) {
        SubItem subItem = this.get(itemStack);
        if (subItem != null && subItem.BURNTIME != null) {
            return subItem.BURNTIME.getInt(CraftTweakerMC.getIItemStack((ItemStack)itemStack));
        }
        return super.getItemBurnTime(itemStack);
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem != null && subItem.RARITY != null) {
            return CTUtil.getRarity(subItem.RARITY.getString(CraftTweakerMC.getIItemStack((ItemStack)stack)));
        }
        return super.getForgeRarity(stack);
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.EFFECT != null) {
            return subItem.EFFECT.getBool(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.func_77636_d(stack);
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ACTION != null) {
            return CTUtil.getAction(subItem.ACTION.getString(CraftTweakerMC.getIItemStack((ItemStack)stack)));
        }
        return super.func_77661_b(stack);
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.MAXUSEDURATION != null) {
            return subItem.MAXUSEDURATION.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.func_77626_a(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        SubItem subItem = this.get(stack);
        if (playerIn.func_71043_e(this.isAlwaysEatable(stack))) {
            playerIn.func_184598_c(handIn);
        }
        if (subItem != null && subItem.RIGHTCLICK != null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.valueOf((String)subItem.RIGHTCLICK.onItemRightClick(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIPlayer((EntityPlayer)playerIn), CTUtil.getHandEquipment(handIn))), (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ITEMUSEFIRST != null) {
            return EnumActionResult.valueOf((String)subItem.ITEMUSEFIRST.onItemUse(CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CTUtil.getHandEquipment(hand), CraftTweakerMC.getIFacing((EnumFacing)side), hitX, hitY, hitZ).toUpperCase());
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving) {
        SubItem subItem = this.get(stack);
        if (this.getHealAmount(stack) > 0 && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
            }
            if (Loader.isModLoaded((String)"applecore")) {
                this.ACCompatability(stack, player);
            } else {
                player.func_71024_bL().func_75122_a(this.getHealAmount(stack), this.getSaturation(stack));
            }
            stack.func_190918_g(1);
        }
        if (subItem != null && subItem.ITEMUSEFINISH != null) {
            return CraftTweakerMC.getItemStack((IItemStack)subItem.ITEMUSEFINISH.onItemUseFinish(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entityLiving)));
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public boolean func_111207_a(@Nonnull ItemStack stack, @Nonnull EntityPlayer playerIn, @Nonnull EntityLivingBase target, @Nonnull EnumHand hand) {
        SubItem subItem = this.get(stack);
        if (this.isWolfsFavorite(stack) && target instanceof EntityWolf && target.func_110143_aJ() < 20.0f && this.getHealAmount(stack) > 0) {
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            target.func_70691_i((float)this.getHealAmount(stack));
            return true;
        }
        if (subItem != null && subItem.ENTITYINTERACTION != null) {
            return subItem.ENTITYINTERACTION.itemInteractionForEntity(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIPlayer((EntityPlayer)playerIn), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)target), CTUtil.getHandEquipment(hand));
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ENTITYHIT != null) {
            return subItem.ENTITYHIT.hitEntity(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)target), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)attacker));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityLiving) {
        SubItem subItem = this.get(stack);
        return subItem.DESTROYBLOCK != null ? subItem.DESTROYBLOCK.onBlockDestroyed(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entityLiving)) : super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77622_d(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityPlayer playerIn) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.CREATED != null) {
            subItem.CREATED.onCreated(CraftTweakerMC.getIItemStackMutable((ItemStack)stack), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIPlayer((EntityPlayer)playerIn));
        } else {
            super.func_77622_d(stack, worldIn, playerIn);
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        Multimap mm = super.getAttributeModifiers(slot, stack);
        if (subItem != null && subItem.ATTACKDAMAGE != null) {
            mm.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", subItem.ATTACKDAMAGE.getValue(CraftTweakerMC.getIEntityEquipmentSlot((EntityEquipmentSlot)slot)), 0));
        }
        if (subItem != null && subItem.ATTACKSPEED != null) {
            mm.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", subItem.ATTACKDAMAGE.getValue(CraftTweakerMC.getIEntityEquipmentSlot((EntityEquipmentSlot)slot)), 0));
        }
        return mm;
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        SubItem subItem = this.get(stack);
        IItemStack iStack = CraftTweakerMC.getIItemStack((ItemStack)stack);
        if (subItem != null && subItem.MAXDAMAGE != null && subItem.ITEMDAMAGE != null) {
            return subItem.ITEMDAMAGE.getInt(iStack) > 0;
        }
        return super.isDamaged(stack);
    }

    public int getHealAmount(ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.HEALAMOUNT != null) {
            return subItem.HEALAMOUNT.getInt(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return 0;
    }

    public float getSaturation(ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.SATURATION != null) {
            return subItem.SATURATION.getFloat(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return 0.0f;
    }

    public boolean isWolfsFavorite(ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.WOLFSFAVORITE != null) {
            return subItem.WOLFSFAVORITE.getBool(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return false;
    }

    public boolean isAlwaysEatable(ItemStack stack) {
        SubItem subItem = this.get(stack);
        if (subItem != null && subItem.ALWAYSEDIBLE != null) {
            return subItem.ALWAYSEDIBLE.getBool(CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return false;
    }

    @Optional.Method(modid="applecore")
    public FoodValues getFoodValues(@Nonnull ItemStack stack) {
        return new FoodValues(this.getHealAmount(stack), this.getSaturation(stack));
    }

    @Optional.Method(modid="applecore")
    public void ACCompatability(ItemStack stack, EntityPlayer player) {
        FoodValues values = this.getFoodValues(stack);
        player.func_71024_bL().func_75122_a(values.hunger, values.saturationModifier);
    }

    @Nonnull
    public String getHighlightTip(@Nonnull ItemStack item, @Nonnull String displayName) {
        String tip;
        SubItem subItem = this.get(item);
        if (subItem != null && subItem.HIGHLIGHTTIP != null && (tip = subItem.HIGHLIGHTTIP.getHighlightTip(CraftTweakerMC.getIItemStack((ItemStack)item), displayName)) != null) {
            return tip;
        }
        return super.getHighlightTip(item, displayName);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack item, @Nonnull EntityPlayer player) {
        SubItem subItem = this.get(item);
        if (subItem != null && subItem.PLAYERDROP != null) {
            return subItem.PLAYERDROP.onDroppedByPlayer(CraftTweakerMC.getIItemStackMutable((ItemStack)item), CraftTweakerMC.getIPlayer((EntityPlayer)player));
        }
        return super.onDroppedByPlayer(item, player);
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return super.doesSneakBypassUse(stack, world, pos, player);
    }

    public boolean isShield(@Nonnull ItemStack stack, @Nullable EntityLivingBase entity) {
        return super.isShield(stack, entity);
    }

    @Override
    public ResourceLocation getLocation(World world, EntityPlayer player, ItemStack stack) {
        SubItem subItem = this.get(stack);
        return subItem.HALOTEXTURE != null ? GeneralUtil.getTextureLocation(subItem.HALOTEXTURE.getTexture(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack))) : null;
    }

    @Override
    public int getSpread(World world, EntityPlayer player, ItemStack stack) {
        SubItem subItem = this.get(stack);
        return subItem.HALOSPREAD != null ? subItem.HALOSPREAD.getSpread(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack)) : 1;
    }

    @Override
    public int getColor(World world, EntityPlayer player, ItemStack stack) {
        SubItem subItem = this.get(stack);
        return subItem.HALOCOLOR != null ? subItem.HALOCOLOR.getColor(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack)) : -16777216;
    }

    @Override
    public boolean shouldPulse(World world, EntityPlayer player, ItemStack stack) {
        SubItem subItem = this.get(stack);
        return subItem.PULSE != null && subItem.PULSE.shouldPulse(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIItemStack((ItemStack)stack));
    }
}

