/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.fluid;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import surreal.contentcreator.common.fluid.FluidBase;
import surreal.contentcreator.types.CTMaterial;
import surreal.contentcreator.util.CTUtil;

public class FluidMaterial
extends FluidBase {
    private final String typeName;
    private final CTMaterial material;

    public FluidMaterial(String typeName, CTMaterial material, ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay) {
        super(typeName + "_" + material.name, still, flowing, overlay);
        this.typeName = typeName;
        this.material = material;
    }

    public static FluidMaterial create(String type, CTMaterial material, String still, String flowing, String overlay) {
        ResourceLocation fl;
        ResourceLocation ol = overlay != null ? new ResourceLocation("contentcreator", "blocks/fluids/" + overlay) : null;
        ResourceLocation st = still != null ? new ResourceLocation("contentcreator", "blocks/fluids/" + still) : STILL_DEFAULT;
        ResourceLocation resourceLocation = fl = flowing != null ? new ResourceLocation("contentcreator", "blocks/fluids/" + flowing) : FLOW_DEFAULT;
        if (ol != null && !TEXTURES.contains(ol)) {
            TEXTURES.add(ol);
        }
        if (!TEXTURES.contains(st)) {
            TEXTURES.add(st);
        }
        if (!TEXTURES.contains(fl)) {
            TEXTURES.add(fl);
        }
        return new FluidMaterial(type, material, st, fl, ol);
    }

    public String getLocalizedName(FluidStack stack) {
        if (this.material != null) {
            return CTUtil.getRarity((String)this.material.rarity).field_77937_e + I18n.func_135052_a((String)("part." + this.typeName), (Object[])new Object[]{this.material.getLocalizedName()});
        }
        return super.getLocalizedName(stack);
    }
}

