/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;
import surreal.contentcreator.ContentCreator;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericCrop
extends BlockCrops
implements IGenericBlock {
    private ItemStack s;
    private ItemStack c;
    private int cMin;

    public BlockGenericCrop(String c, int meta, int cMin) {
        this.c = GameRegistry.makeItemStack((String)c, (int)meta, (int)1, null);
        this.cMin = Math.max(cMin, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        int age = this.func_185527_x(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.func_185526_g()) {
            for (int i = 0; i < rand.nextInt(this.cMin) + 1; ++i) {
                ContentCreator.getLogger().info("Adding " + this.c.func_77973_b().getRegistryName() + " to drops.");
                drops.add((Object)this.c);
            }
        }
        drops.add((Object)this.s);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List drops = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockGenericCrop.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_185525_y(state) ? this.c.func_77960_j() : this.s.func_77960_j();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.func_185525_y(state) ? this.c.func_77973_b() : this.s.func_77973_b();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.s;
    }

    protected Item func_149865_P() {
        return Items.field_190931_a;
    }

    protected Item func_149866_i() {
        return Items.field_190931_a;
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }

    @Override
    public Item createItem(Block block) {
        Item seeds = ((Item)new ItemSeeds(block, Blocks.field_150458_ak).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a());
        this.s = new ItemStack(seeds);
        return seeds;
    }
}

