/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block;

import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.util.IAxisAlignedBB;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.common.item.ItemBlockBase;
import surreal.contentcreator.functions.block.IBlockActivatedFunc;
import surreal.contentcreator.functions.block.IBlockAddFunc;
import surreal.contentcreator.functions.block.IBlockBeaconBaseFunc;
import surreal.contentcreator.functions.block.IBlockBeaconMultiplierFunc;
import surreal.contentcreator.functions.block.IBlockBoundingBox;
import surreal.contentcreator.functions.block.IBlockBreakFunc;
import surreal.contentcreator.functions.block.IBlockBurnFunc;
import surreal.contentcreator.functions.block.IBlockCollisionBox;
import surreal.contentcreator.functions.block.IBlockColorFunc;
import surreal.contentcreator.functions.block.IBlockConnectRedstoneFunc;
import surreal.contentcreator.functions.block.IBlockDestroyExplosionFunc;
import surreal.contentcreator.functions.block.IBlockDestroyedPlayerFunc;
import surreal.contentcreator.functions.block.IBlockDropsFunc;
import surreal.contentcreator.functions.block.IBlockEnchantPowerFunc;
import surreal.contentcreator.functions.block.IBlockEntityCollideFunc;
import surreal.contentcreator.functions.block.IBlockEntityDestroyFunc;
import surreal.contentcreator.functions.block.IBlockEntityWalkFunc;
import surreal.contentcreator.functions.block.IBlockFaceShapeFunc;
import surreal.contentcreator.functions.block.IBlockFireSourceFunc;
import surreal.contentcreator.functions.block.IBlockHardnessFunc;
import surreal.contentcreator.functions.block.IBlockHarvestFunc;
import surreal.contentcreator.functions.block.IBlockLadderFunc;
import surreal.contentcreator.functions.block.IBlockLightFunc;
import surreal.contentcreator.functions.block.IBlockMapColorFunc;
import surreal.contentcreator.functions.block.IBlockMaterialFunc;
import surreal.contentcreator.functions.block.IBlockNeighborChangeFunc;
import surreal.contentcreator.functions.block.IBlockOffsetFunc;
import surreal.contentcreator.functions.block.IBlockPassableFunc;
import surreal.contentcreator.functions.block.IBlockPlaceFunc;
import surreal.contentcreator.functions.block.IBlockPlaceSideFunc;
import surreal.contentcreator.functions.block.IBlockPlaceTorchTopFunc;
import surreal.contentcreator.functions.block.IBlockPlacedBy;
import surreal.contentcreator.functions.block.IBlockPowerFunc;
import surreal.contentcreator.functions.block.IBlockRemovedPlayerFunc;
import surreal.contentcreator.functions.block.IBlockResistanceFunc;
import surreal.contentcreator.functions.block.IBlockSlipperinessFunc;
import surreal.contentcreator.functions.block.IBlockSoundFunc;
import surreal.contentcreator.functions.block.IBlockStateBooleanFunc;
import surreal.contentcreator.functions.block.IBlockStateForPlacementFunc;
import surreal.contentcreator.functions.block.IBlockStateViewFunc;
import surreal.contentcreator.functions.block.IBlockSubItemFunc;
import surreal.contentcreator.functions.block.IBlockTickRateFunc;
import surreal.contentcreator.functions.block.IBlockUpdateTickFunc;
import surreal.contentcreator.functions.item.IItemUnlocalizedNameFunc;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.types.CTSoundType;
import surreal.contentcreator.util.CTUtil;

@ZenRegister
@ZenClass(value="contentcreator.block.Block")
public class BlockBase
extends Block {
    private BlockRenderLayer layer = BlockRenderLayer.SOLID;
    private Block.EnumOffsetType offset = Block.EnumOffsetType.NONE;
    private List<AxisAlignedBB> COLLISION_BOXES = null;
    private AxisAlignedBB SELECTED_BOX = null;
    private boolean shouldDrop = false;
    public IBlockColorFunc COLOR = null;
    private IBlockMaterialFunc MATERIAL = null;
    private IBlockMapColorFunc MAPCOLOR = null;
    private IBlockHardnessFunc HARDNESS = null;
    private IBlockResistanceFunc RESISTANCE = null;
    private IBlockDestroyExplosionFunc EXPLOSION = null;
    private IBlockStateBooleanFunc OPAQUE = null;
    private IBlockStateBooleanFunc SUFFOCATION = null;
    private IBlockPassableFunc PASSABLE = null;
    private IBlockFaceShapeFunc FACESHAPE = null;
    private IBlockUpdateTickFunc UPDATETICK = null;
    private IBlockUpdateTickFunc DISPLAYTICK = null;
    private IBlockDestroyedPlayerFunc DESTROYPLAYER = null;
    private IBlockNeighborChangeFunc NEIGHBORCHANGED = null;
    private IBlockTickRateFunc TICKRATE = null;
    private IBlockAddFunc ADDED = null;
    private IBlockBreakFunc BREAK = null;
    private IBlockPlaceSideFunc PLACESIDE = null;
    private IBlockPlaceFunc PLACE = null;
    private IBlockActivatedFunc ACTIVATED = null;
    private IBlockEntityWalkFunc ENTITYWALK = null;
    private IBlockStateForPlacementFunc STATEPLACEMENT = null;
    private IBlockPowerFunc WEAKPOWER = null;
    private IBlockPowerFunc STRONGPOWER = null;
    private IBlockEntityCollideFunc ENTITYCOLLIDE = null;
    private IBlockPlacedBy PLACEDBY = null;
    private IBlockHarvestFunc HARVEST = null;
    private IBlockOffsetFunc OFFSET = null;
    private IBlockSlipperinessFunc SLIPPERINESS = null;
    private IBlockLightFunc LIGHTVALUE = null;
    private IBlockLadderFunc LADDER = null;
    private IBlockRemovedPlayerFunc REMOVEDPLAYER = null;
    private IBlockBurnFunc FLAMMABILITY = null;
    private IBlockBurnFunc FIRESPREAD = null;
    private IBlockFireSourceFunc FIRESOURCE = null;
    private IBlockConnectRedstoneFunc CONNECTREDSTONE = null;
    private IBlockPlaceTorchTopFunc TORCHTOP = null;
    private IBlockLightFunc LIGHTOPACITY = null;
    private IBlockEntityDestroyFunc ENTITYDESTROY = null;
    private IBlockBeaconBaseFunc BEACONBASE = null;
    private IBlockEnchantPowerFunc ENCHANTPOWER = null;
    private IBlockSoundFunc SOUND = null;
    private IBlockBeaconMultiplierFunc BEACONMULTIPLIER = null;
    private IBlockStateViewFunc VIEW = null;
    private IBlockStateBooleanFunc STICKY = null;
    private IBlockDropsFunc DROPS = null;
    private IBlockCollisionBox COLLISIONBOXLIST = null;
    private IBlockBoundingBox BOUNDINGBOX = null;
    public IItemUnlocalizedNameFunc ITEMUNLOCNAME = null;
    private IBlockSubItemFunc SUBITEM = null;
    private static PropertyDirection FACING = null;
    private static PropertyInteger INT = null;

    @ZenMethod
    public static void setFacing(String name) {
        FACING = PropertyDirection.func_177714_a((String)name);
    }

    @ZenMethod
    public static void setFacing(String name, IFacing ... facings) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        for (IFacing facing : facings) {
            faces.add(CraftTweakerMC.getFacing((IFacing)facing));
        }
        FACING = PropertyDirection.func_177713_a((String)name, faces);
    }

    @ZenMethod
    public static void setInteger(String name, int min, int max) {
        max = Math.min(max, 15);
        INT = PropertyInteger.func_177719_a((String)name, (int)Math.max(min, 0), (int)max);
    }

    @ZenMethod
    public static void setInteger(String name, int max) {
        INT = PropertyInteger.func_177719_a((String)name, (int)0, (int)Math.min(max, 15));
    }

    public BlockBase(Material materialIn) {
        super(materialIn);
        if (FACING != null) {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }
        if (INT != null) {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)INT, (Comparable)BlockBase.intProperty()[0]));
        }
        this.func_149647_a(CreativeTabs.field_78027_g);
    }

    @ZenMethod
    public static BlockBase create(IMaterial material, String name) {
        BlockBase base = new BlockBase(CraftTweakerMC.getMaterial((IMaterial)material));
        ((Block)base.setRegistryName("contentcreator", name)).func_149663_c("contentcreator." + name);
        CommonProxy.BLOCKS.add(base);
        if (FACING != null || INT != null) {
            BlockBase.clear();
        }
        return base;
    }

    @ZenMethod
    public static BlockBase getBlock(String name) {
        for (Block block : CommonProxy.BLOCKS) {
            if (!block.getRegistryName().toString().equals(name)) continue;
            return (BlockBase)block;
        }
        return null;
    }

    @ZenMethod
    public static BlockBase getBlock(IItemStack stack) {
        return (BlockBase)Block.func_149634_a((Item)CraftTweakerMC.getItem((IItemDefinition)stack.getDefinition()));
    }

    @ZenMethod
    public static BlockBase getBlock(IItemDefinition definition) {
        return (BlockBase)Block.func_149634_a((Item)CraftTweakerMC.getItem((IItemDefinition)definition));
    }

    @Nonnull
    public Material func_149688_o(@Nonnull IBlockState state) {
        return this.MATERIAL != null ? CraftTweakerMC.getMaterial((IMaterial)this.MATERIAL.getMaterial(CraftTweakerMC.getBlockState((IBlockState)state))) : super.func_149688_o(state);
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.MAPCOLOR != null ? this.MAPCOLOR.getMapColor(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos)) : super.func_180659_g(state, worldIn, pos);
    }

    public float func_176195_g(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (this.HARDNESS != null) {
            return this.HARDNESS.getBlockHardness(CraftTweakerMC.getBlockState((IBlockState)blockState), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos));
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        if (this.RESISTANCE != null) {
            return this.RESISTANCE.getExplosionResistance(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntity((Entity)exploder), CraftTweakerMC.getIExplosion((Explosion)explosion));
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public void onBlockExploded(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        if (this.EXPLOSION != null) {
            this.EXPLOSION.onBlockExploded(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIExplosion((Explosion)explosion));
        } else {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.OPAQUE != null ? this.OPAQUE.check(CraftTweakerMC.getBlockState((IBlockState)state)) : super.func_149662_c(state);
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.OPAQUE != null ? this.OPAQUE.check(CraftTweakerMC.getBlockState((IBlockState)state)) : super.func_149686_d(state);
    }

    public boolean func_176214_u(@Nonnull IBlockState state) {
        return this.SUFFOCATION != null ? this.SUFFOCATION.check(CraftTweakerMC.getBlockState((IBlockState)state)) : super.func_176214_u(state);
    }

    public boolean func_176205_b(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.PASSABLE != null ? this.PASSABLE.isPassable(CTUtil.getIBlockAccess(worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos)) : super.func_176205_b(worldIn, pos);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.FACESHAPE != null ? BlockFaceShape.valueOf((String)this.FACESHAPE.getBlockFaceShape(CTUtil.getIBlockAccess(worldIn), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)face)).toUpperCase()) : super.func_193383_a(worldIn, state, pos, face);
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.COLLISIONBOXLIST != null) {
            for (IAxisAlignedBB aabb2 : this.COLLISIONBOXLIST.getCollisionBoxList(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIAxisAlignedBB((AxisAlignedBB)entityBox), CraftTweakerMC.getIEntity((Entity)entityIn), isActualState)) {
                BlockBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)aabb2));
            }
        } else if (this.BOUNDINGBOX != null) {
            BlockBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)this.BOUNDINGBOX.getBoundingBox(CTUtil.getIBlockAccess((IBlockAccess)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state))));
        } else if (this.COLLISION_BOXES != null) {
            this.COLLISION_BOXES.forEach(aabb -> BlockBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)aabb));
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return this.BOUNDINGBOX != null ? CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)this.BOUNDINGBOX.getBoundingBox(CTUtil.getIBlockAccess(source), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state))) : (this.SELECTED_BOX != null ? this.SELECTED_BOX : super.func_185496_a(state, source, pos));
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (this.UPDATETICK != null) {
            this.UPDATETICK.updateTick(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getRandom(rand));
        } else {
            super.func_180650_b(worldIn, pos, state, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (this.DISPLAYTICK != null) {
            this.DISPLAYTICK.updateTick(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)stateIn), CTUtil.getRandom(rand));
        } else {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        }
    }

    public void func_176206_d(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.DESTROYPLAYER != null) {
            this.DESTROYPLAYER.onBlockDestroyed(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state));
        } else {
            super.func_176206_d(worldIn, pos, state);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        IWorld iworld = CraftTweakerMC.getIWorld((World)worldIn);
        IBlockPos ipos = CraftTweakerMC.getIBlockPos((BlockPos)pos);
        if (this.shouldDrop && this.PLACE != null && !this.PLACE.canPlaceBlockAt(iworld, ipos)) {
            this.dropBlock(iworld, ipos, 1.0f, 0);
        }
        if (this.NEIGHBORCHANGED != null) {
            this.NEIGHBORCHANGED.onNeighborChanged(CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockDefinition((Block)blockIn), CraftTweakerMC.getIBlockPos((BlockPos)fromPos));
        } else {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }
    }

    public int func_149738_a(@Nonnull World worldIn) {
        return this.TICKRATE != null ? this.TICKRATE.tickRate(CraftTweakerMC.getIWorld((World)worldIn)) : super.func_149738_a(worldIn);
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.ADDED != null) {
            this.ADDED.onBlockAdded(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state));
        } else {
            super.func_176213_c(worldIn, pos, state);
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (this.BREAK != null) {
            this.BREAK.breakBlock(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.PLACESIDE != null ? this.PLACESIDE.canPlaceBlockOnSide(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side)) : super.func_176198_a(worldIn, pos, side);
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        return this.PLACE != null ? this.PLACE.canPlaceBlockAt(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos)) : super.func_176196_c(worldIn, pos);
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.ACTIVATED != null ? this.ACTIVATED.onBlockActivated(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIPlayer((EntityPlayer)playerIn), CTUtil.getHandEquipment(hand), CraftTweakerMC.getIFacing((EnumFacing)facing), hitX, hitY, hitZ) : super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176199_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        if (this.ENTITYWALK != null) {
            this.ENTITYWALK.onEntityWalk(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntity((Entity)entityIn));
        } else {
            super.func_176199_a(worldIn, pos, entityIn);
        }
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.STATEPLACEMENT != null ? CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)this.STATEPLACEMENT.getStateForPlacement(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)facing), hitX, hitY, hitZ, meta, CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)placer))) : super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public int func_180656_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.WEAKPOWER != null ? this.WEAKPOWER.getPower(CraftTweakerMC.getBlockState((IBlockState)blockState), CTUtil.getIBlockAccess(blockAccess), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side)) : super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.STRONGPOWER != null ? this.STRONGPOWER.getPower(CraftTweakerMC.getBlockState((IBlockState)blockState), CTUtil.getIBlockAccess(blockAccess), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side)) : (this.WEAKPOWER != null ? this.WEAKPOWER.getPower(CraftTweakerMC.getBlockState((IBlockState)blockState), CTUtil.getIBlockAccess(blockAccess), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side)) : super.func_176211_b(blockState, blockAccess, pos, side));
    }

    public boolean func_149744_f(@Nonnull IBlockState state) {
        return this.WEAKPOWER != null || this.STRONGPOWER != null || super.func_149744_f(state);
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (this.ENTITYCOLLIDE != null) {
            this.ENTITYCOLLIDE.onEntityCollidedWithBlock(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIEntity((Entity)entityIn));
        } else {
            super.func_180634_a(worldIn, pos, state, entityIn);
        }
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (this.PLACEDBY != null) {
            this.PLACEDBY.onBlockPlacedBy(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)placer), CraftTweakerMC.getIItemStackMutable((ItemStack)stack));
        } else {
            super.func_180633_a(worldIn, pos, state, placer, stack);
        }
    }

    public void func_149666_a(@Nonnull CreativeTabs itemIn, @Nonnull NonNullList<ItemStack> items) {
        if (this.SUBITEM != null) {
            ImmutableList states = this.field_176227_L.func_177619_a();
            for (int i = 0; i < states.size(); ++i) {
                if (!this.SUBITEM.check(CraftTweakerMC.getBlockState((IBlockState)((IBlockState)states.get(i))))) continue;
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        } else {
            super.func_149666_a(itemIn, items);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (this.SUBITEM != null && this.SUBITEM.check(CraftTweakerMC.getBlockState((IBlockState)state))) {
            return new ItemStack((Block)this, 1, this.func_176201_c(state));
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_176208_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        if (this.HARVEST != null) {
            this.HARVEST.onBlockHarvested(CraftTweakerMC.getIWorld((World)worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIPlayer((EntityPlayer)player));
        } else {
            super.func_176208_a(worldIn, pos, state, player);
        }
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return this.offset;
    }

    @Nonnull
    public Vec3d func_190949_e(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.OFFSET != null ? CraftTweakerMC.getVec3d((IVector3d)this.OFFSET.getOffset(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(worldIn), CraftTweakerMC.getIBlockPos((BlockPos)pos))) : super.func_190949_e(state, worldIn, pos);
    }

    public float getSlipperiness(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        return this.SLIPPERINESS != null ? this.SLIPPERINESS.getSlipperiness(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntity((Entity)entity)) : super.getSlipperiness(state, world, pos, entity);
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.LIGHTVALUE != null ? this.LIGHTVALUE.getLightValue(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos)) : super.getLightValue(state, world, pos);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos beaconPos) {
        if (this.BEACONMULTIPLIER != null) {
            return this.BEACONMULTIPLIER.getBeaconColorMultiplier(CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIBlockPos((BlockPos)beaconPos));
        }
        return super.getBeaconColorMultiplier(state, world, pos, beaconPos);
    }

    public boolean isLadder(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return this.LADDER != null ? this.LADDER.isLadder(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entity)) : super.isLadder(state, world, pos, entity);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (this.REMOVEDPLAYER != null) {
            return this.REMOVEDPLAYER.removedByPlayer(CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIPlayer((EntityPlayer)player), willHarvest);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        if (this.FLAMMABILITY != null) {
            return this.FLAMMABILITY.getBurn(CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)face));
        }
        return super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        if (this.FIRESPREAD != null) {
            return this.FIRESPREAD.getBurn(CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)face));
        }
        return super.getFireSpreadSpeed(world, pos, face);
    }

    public boolean isFireSource(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (this.FIRESOURCE != null) {
            return this.FIRESOURCE.getBurn((crafttweaker.api.world.IBlockAccess)CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side));
        }
        return super.isFireSource(world, pos, side);
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.TORCHTOP != null) {
            return this.TORCHTOP.canPlaceTorchOnTop(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos));
        }
        return super.canPlaceTorchOnTop(state, world, pos);
    }

    public int getLightOpacity(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.LIGHTOPACITY != null) {
            return this.LIGHTOPACITY.getLightValue(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos));
        }
        return super.getLightOpacity(state, world, pos);
    }

    public boolean canEntityDestroy(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (this.ENTITYDESTROY != null) {
            return this.ENTITYDESTROY.canEntityDestroy(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntity((Entity)entity));
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    @Nonnull
    public IBlockState getStateAtViewpoint(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Vec3d viewpoint) {
        if (this.VIEW != null) {
            return CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)this.VIEW.getStateAtViewpoint(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIVector3d((Vec3d)viewpoint)));
        }
        return super.getStateAtViewpoint(state, world, pos, viewpoint);
    }

    public boolean isStickyBlock(@Nonnull IBlockState state) {
        if (this.STICKY != null) {
            return this.STICKY.check(CraftTweakerMC.getBlockState((IBlockState)state));
        }
        return super.isStickyBlock(state);
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        if (this.SOUND != null) {
            return this.SOUND.getSoundType(CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIEntity((Entity)entity)).getInternal();
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public float getEnchantPowerBonus(@Nonnull World world, @Nonnull BlockPos pos) {
        if (this.ENCHANTPOWER != null) {
            return this.ENCHANTPOWER.getEnchantPowerBonus(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos));
        }
        return super.getEnchantPowerBonus(world, pos);
    }

    public boolean isBeaconBase(@Nonnull IBlockAccess worldObj, @Nonnull BlockPos pos, @Nonnull BlockPos beacon) {
        if (this.BEACONBASE != null) {
            return this.BEACONBASE.isBeaconBase(CTUtil.getIBlockAccess(worldObj), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIBlockPos((BlockPos)beacon));
        }
        return super.isBeaconBase(worldObj, pos, beacon);
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        if (this.CONNECTREDSTONE != null) {
            return this.CONNECTREDSTONE.canConnectRedstone(CraftTweakerMC.getBlockState((IBlockState)state), CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getIFacing((EnumFacing)side));
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.DROPS != null) {
            Collections.addAll(drops, CraftTweakerMC.getItemStacks((IItemStack[])this.DROPS.getDrops(CTUtil.getIBlockAccess(world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), fortune)));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        if (!state.func_177227_a().isEmpty()) {
            PropertyDirection facing = BlockBase.getFacing(state);
            PropertyInteger integer = BlockBase.getInteger(state);
            int meta = 0;
            int increment = 0;
            if (integer != null) {
                ArrayList allowedVal = new ArrayList(integer.func_177700_c());
                meta = allowedVal.indexOf(state.func_177229_b((IProperty)integer));
            }
            if (facing != null) {
                increment = Arrays.asList(EnumFacing.values()).indexOf(state.func_177229_b((IProperty)facing));
                if (integer != null) {
                    increment *= integer.func_177700_c().size();
                }
            }
            return meta += increment;
        }
        return super.func_176201_c(state);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (this.func_176223_P().func_177227_a().size() > 0) {
            PropertyDirection facing = BlockBase.getFacing(this.func_176223_P());
            PropertyInteger integer = BlockBase.getInteger(this.func_176223_P());
            IBlockState state = this.func_176223_P();
            int intg = -1;
            int face = -1;
            if (integer != null) {
                intg = meta % integer.func_177700_c().size();
            }
            if (facing != null) {
                face = meta;
                if (intg >= 0) {
                    face = meta / integer.func_177700_c().size();
                }
            }
            if (facing != null) {
                state = state.func_177226_a((IProperty)facing, (Comparable)EnumFacing.values()[face]);
            }
            if (integer != null) {
                state = state.func_177226_a((IProperty)integer, (Comparable)Integer.valueOf(intg));
            }
            return state;
        }
        return super.func_176203_a(meta);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        ArrayList<Object> properties = new ArrayList<Object>();
        if (FACING != null) {
            properties.add(FACING);
        }
        if (INT != null) {
            properties.add(INT);
        }
        return properties.size() > 0 ? new BlockStateContainer((Block)this, properties.toArray(new IProperty[properties.size()])) : super.func_180661_e();
    }

    @ZenMethod
    public BlockBase setMaterial(IBlockMaterialFunc func) {
        this.MATERIAL = func;
        return this;
    }

    @ZenMethod
    public BlockBase setMapColor(IBlockMapColorFunc func) {
        this.MAPCOLOR = func;
        return this;
    }

    @ZenMethod
    public BlockBase setMapColor(MapColor color) {
        this.MAPCOLOR = (state, world, pos) -> color;
        return this;
    }

    @ZenMethod(value="setHardness")
    public BlockBase setHard(float hardness) {
        this.HARDNESS = (state, world, pos) -> hardness;
        return this;
    }

    @ZenMethod
    public BlockBase setHardness(IBlockHardnessFunc func) {
        this.HARDNESS = func;
        return this;
    }

    @ZenMethod
    public BlockBase setUnbreakable() {
        this.HARDNESS = (state, world, pos) -> -1.0f;
        return this;
    }

    @ZenMethod(value="setResistance")
    public BlockBase setRes(float resistance) {
        this.RESISTANCE = (world, pos, entity, explosion) -> resistance;
        return this;
    }

    @ZenMethod
    public BlockBase setResistance(IBlockResistanceFunc func) {
        this.RESISTANCE = func;
        return this;
    }

    @ZenMethod
    public BlockBase onBlockExploded(IBlockDestroyExplosionFunc func) {
        this.EXPLOSION = func;
        return this;
    }

    @ZenMethod
    public BlockBase setNonOpaque() {
        this.OPAQUE = state -> false;
        return this;
    }

    @ZenMethod
    public BlockBase setOpaque(IBlockStateBooleanFunc func) {
        this.OPAQUE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSuffocation() {
        this.SUFFOCATION = state -> true;
        return this;
    }

    @ZenMethod
    public BlockBase setSuffocation(IBlockStateBooleanFunc func) {
        this.SUFFOCATION = func;
        return this;
    }

    @ZenMethod
    public BlockBase setPassable() {
        this.PASSABLE = (world, pos) -> true;
        return this;
    }

    @ZenMethod
    public BlockBase setPassable(IBlockPassableFunc func) {
        this.PASSABLE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setFaceShape(String faceShape) {
        this.FACESHAPE = (world, state, pos, facing) -> faceShape.toUpperCase();
        return this;
    }

    @ZenMethod
    public BlockBase setFaceShape(IBlockFaceShapeFunc func) {
        this.FACESHAPE = func;
        return this;
    }

    @ZenMethod
    public BlockBase addCollisionBox(IAxisAlignedBB aabb) {
        if (this.COLLISION_BOXES == null) {
            this.COLLISION_BOXES = new ArrayList<AxisAlignedBB>();
        }
        if (aabb != null) {
            this.COLLISION_BOXES.add(CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)aabb));
        }
        return this;
    }

    @ZenMethod
    public BlockBase addCollisionBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.COLLISION_BOXES == null) {
            this.COLLISION_BOXES = new ArrayList<AxisAlignedBB>();
        }
        this.COLLISION_BOXES.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        return this;
    }

    @ZenMethod
    public BlockBase setSelectedBox(IAxisAlignedBB aabb) {
        if (aabb != null) {
            this.SELECTED_BOX = CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)aabb);
        }
        return this;
    }

    @ZenMethod
    public BlockBase setSelectedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.SELECTED_BOX = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        return this;
    }

    @ZenMethod
    public BlockBase setBoundingBox(IAxisAlignedBB aabb) {
        if (aabb != null) {
            AxisAlignedBB ab = CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)aabb);
            if (this.COLLISION_BOXES == null) {
                this.COLLISION_BOXES = new ArrayList<AxisAlignedBB>();
            }
            this.COLLISION_BOXES.add(ab);
            this.SELECTED_BOX = ab;
        }
        return this;
    }

    @ZenMethod
    public BlockBase setBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        if (this.COLLISION_BOXES == null) {
            this.COLLISION_BOXES = new ArrayList<AxisAlignedBB>();
        }
        this.COLLISION_BOXES.add(aabb);
        this.SELECTED_BOX = aabb;
        return this;
    }

    @ZenMethod
    public BlockBase setUpdateTick(IBlockUpdateTickFunc func) {
        this.UPDATETICK = func;
        return this;
    }

    @ZenMethod
    public BlockBase setDisplayTick(IBlockUpdateTickFunc func) {
        this.DISPLAYTICK = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBlockDestroyedByPlayer(IBlockDestroyedPlayerFunc func) {
        this.DESTROYPLAYER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setNeighborChange(IBlockNeighborChangeFunc func) {
        this.NEIGHBORCHANGED = func;
        return this;
    }

    @ZenMethod
    public BlockBase setTickRate(IBlockTickRateFunc func) {
        this.func_149675_a(true);
        this.TICKRATE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBlockAdded(IBlockAddFunc func) {
        this.ADDED = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBlockBreak(IBlockBreakFunc func) {
        this.BREAK = func;
        return this;
    }

    @ZenMethod
    public BlockBase setRenderLayer(String layer) {
        this.layer = BlockRenderLayer.valueOf((String)layer.toUpperCase());
        return this;
    }

    @ZenMethod
    public BlockBase canPlaceSide(IBlockPlaceSideFunc func) {
        this.PLACESIDE = func;
        return this;
    }

    @ZenMethod
    public BlockBase canPlace(IBlockPlaceFunc func) {
        this.PLACE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBlockActivated(IBlockActivatedFunc func) {
        this.ACTIVATED = func;
        return this;
    }

    @ZenMethod
    public BlockBase setEntityWalk(IBlockEntityWalkFunc func) {
        this.ENTITYWALK = func;
        return this;
    }

    @ZenMethod
    public BlockBase setStateForPlacement(IBlockStateForPlacementFunc func) {
        this.STATEPLACEMENT = func;
        return this;
    }

    @ZenMethod
    public BlockBase setWeakPower(int power) {
        this.WEAKPOWER = (state, world, pos, facing) -> power;
        return this;
    }

    @ZenMethod
    public BlockBase setWeakPower(IBlockPowerFunc func) {
        this.WEAKPOWER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setStrongPower(int power) {
        this.STRONGPOWER = (state, world, pos, facing) -> power;
        return this;
    }

    @ZenMethod
    public BlockBase setStrongPower(IBlockPowerFunc func) {
        this.STRONGPOWER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setEntityCollide(IBlockEntityCollideFunc func) {
        this.ENTITYCOLLIDE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setPlacedBy(IBlockPlacedBy func) {
        this.PLACEDBY = func;
        return this;
    }

    @ZenMethod
    public BlockBase setUnlocalizedName(IItemUnlocalizedNameFunc func) {
        this.ITEMUNLOCNAME = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSubItems() {
        return this.setSubItems(state -> true);
    }

    @ZenMethod
    public BlockBase setSubItem() {
        return this.setSubItems(state -> this.func_176201_c(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state)) == 0);
    }

    @ZenMethod
    public BlockBase setSubItems(IBlockSubItemFunc func) {
        this.SUBITEM = func;
        CommonProxy.ITEMBLOCKS.add((Item)new ItemBlockBase(this));
        return this;
    }

    @ZenMethod
    public BlockBase setBlockHarvest(IBlockHarvestFunc func) {
        this.HARVEST = func;
        return this;
    }

    @ZenMethod
    public BlockBase setOffset(String offset) {
        this.offset = Block.EnumOffsetType.valueOf((String)offset);
        return this;
    }

    @ZenMethod
    public BlockBase setOffset(IBlockOffsetFunc func) {
        this.OFFSET = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSlipperiness(float slipperiness) {
        this.SLIPPERINESS = (state, world, pos, entity) -> slipperiness;
        return this;
    }

    @ZenMethod
    public BlockBase setSlipperiness(IBlockSlipperinessFunc func) {
        this.SLIPPERINESS = func;
        return this;
    }

    @ZenMethod
    public BlockBase setLightValue(int lightValue) {
        this.LIGHTVALUE = (state, world, pos) -> lightValue;
        return this;
    }

    @ZenMethod
    public BlockBase setLightValue(IBlockLightFunc func) {
        this.LIGHTVALUE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setLadder() {
        this.LADDER = (state, world, pos, entity) -> true;
        return this;
    }

    @ZenMethod
    public BlockBase isLadder(IBlockLadderFunc func) {
        this.LADDER = func;
        return this;
    }

    @ZenMethod
    public BlockBase onRemovedByPlayer(IBlockRemovedPlayerFunc func) {
        this.REMOVEDPLAYER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setFlammability(int flammability) {
        this.FLAMMABILITY = (world, pos, facing) -> flammability;
        return this;
    }

    @ZenMethod
    public BlockBase setFlammability(IBlockBurnFunc func) {
        this.FLAMMABILITY = func;
        return this;
    }

    @ZenMethod
    public BlockBase setFireSpread(int fireSpread) {
        this.FIRESPREAD = (world, pos, facing) -> fireSpread;
        return this;
    }

    @ZenMethod
    public BlockBase setFireSpread(IBlockBurnFunc func) {
        this.FIRESPREAD = func;
        return this;
    }

    @ZenMethod
    public BlockBase setFireSource() {
        this.FIRESOURCE = (world, pos, facing) -> true;
        return this;
    }

    @ZenMethod
    public BlockBase isFireSource(IBlockFireSourceFunc func) {
        this.FIRESOURCE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setConnectRedstone() {
        this.CONNECTREDSTONE = (state, world, pos, facing) -> true;
        return this;
    }

    @ZenMethod
    public BlockBase canConnectRedstone(IBlockConnectRedstoneFunc func) {
        this.CONNECTREDSTONE = func;
        return this;
    }

    @ZenMethod
    public BlockBase canPlaceTorchOnTop(IBlockPlaceTorchTopFunc func) {
        this.TORCHTOP = func;
        return this;
    }

    @ZenMethod(value="setLightOpacity")
    public BlockBase setLO(int lightOpacity) {
        this.LIGHTOPACITY = (state, world, pos) -> lightOpacity;
        return this;
    }

    @ZenMethod
    public BlockBase setLightOpacity(IBlockLightFunc func) {
        this.LIGHTOPACITY = func;
        return this;
    }

    @ZenMethod
    public BlockBase canEntityDestroy(IBlockEntityDestroyFunc func) {
        this.ENTITYDESTROY = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBeaconBase(IBlockBeaconBaseFunc func) {
        this.BEACONBASE = func;
        return this;
    }

    @ZenMethod
    public BlockBase setEnchantPower(IBlockEnchantPowerFunc func) {
        this.ENCHANTPOWER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSoundType(IBlockSoundFunc func) {
        this.SOUND = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSoundType(CTSoundType soundType) {
        this.SOUND = (state, world, pos, entity) -> soundType;
        return this;
    }

    @ZenMethod
    public BlockBase setBeaconMultiplier(IBlockBeaconMultiplierFunc func) {
        this.BEACONMULTIPLIER = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBeaconMultiplier(float[] multiplier) {
        this.BEACONMULTIPLIER = (state, world, pos, beaconPos) -> multiplier;
        return this;
    }

    @ZenMethod
    public BlockBase setStateAtViewpoint(IBlockStateViewFunc func) {
        this.VIEW = func;
        return this;
    }

    @ZenMethod
    public BlockBase isSticky(IBlockStateBooleanFunc func) {
        this.STICKY = func;
        return this;
    }

    @ZenMethod
    public BlockBase setSticky() {
        this.STICKY = state -> true;
        return this;
    }

    @ZenMethod
    public BlockBase setColor(IBlockColorFunc func) {
        this.COLOR = func;
        return this;
    }

    @ZenMethod
    public BlockBase setColor(int color) {
        this.COLOR = (state, tintIndex) -> color;
        return this;
    }

    @ZenMethod(value="setHarvestLevel")
    public BlockBase setHarvestLvl(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @ZenMethod(value="setHarvestLevel")
    public BlockBase setHarvestLvl(String tool, int level, IBlockStateMatcher matcher) {
        for (crafttweaker.api.block.IBlockState state : matcher.getMatchingBlockStates()) {
            this.setHarvestLevel(tool, level, (IBlockState)state);
        }
        return this;
    }

    @ZenMethod(value="setHarvestLevel")
    public BlockBase setHarvestLvl(String tool, int level, int[] matcher) {
        for (int i : matcher) {
            IBlockState state = this.func_176203_a(i);
            this.setHarvestLevel(tool, level, state);
        }
        return this;
    }

    @ZenMethod
    public BlockBase setCollisionBox(IBlockCollisionBox func) {
        this.COLLISIONBOXLIST = func;
        return this;
    }

    @ZenMethod
    public BlockBase setBoundingBox(IBlockBoundingBox func) {
        this.BOUNDINGBOX = func;
        return this;
    }

    @ZenMethod
    public void dropBlock(IWorld world, IBlockPos pos, @Optional float chance, @Optional int fortune) {
        World w = CraftTweakerMC.getWorld((IWorld)world);
        BlockPos bp = CraftTweakerMC.getBlockPos((IBlockPos)pos);
        IBlockState state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)world.getBlockState(pos));
        if (chance == 0.0f) {
            chance = 1.0f;
        }
        this.func_180653_a(w, bp, state, chance, fortune);
        w.func_175698_g(bp);
    }

    @ZenMethod
    public BlockBase setDrops(IBlockDropsFunc func) {
        this.DROPS = func;
        return this;
    }

    @ZenMethod
    public BlockBase setDrops(IItemStack[] drops) {
        this.DROPS = (world, pos, state, fortune) -> drops;
        return this;
    }

    @ZenMethod
    public BlockBase checkAndDropBlock() {
        this.shouldDrop = true;
        return this;
    }

    private static Integer[] intProperty() {
        if (INT == null) {
            return null;
        }
        return INT.func_177700_c().toArray(new Integer[INT.func_177700_c().size()]);
    }

    private static PropertyDirection getFacing(IBlockState state) {
        for (IProperty property : state.func_177227_a()) {
            if (!(property instanceof PropertyDirection)) continue;
            return (PropertyDirection)property;
        }
        return null;
    }

    private static PropertyInteger getInteger(IBlockState state) {
        for (IProperty property : state.func_177227_a()) {
            if (!(property instanceof PropertyInteger)) continue;
            return (PropertyInteger)property;
        }
        return null;
    }

    public static void clear() {
        FACING = null;
        INT = null;
    }
}

