/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import net.minecraft.nbt.NBTTagCompound;

public class VecN {
    public final double[] x;

    public VecN(int n) {
        this.x = new double[n];
    }

    public VecN(double ... x) {
        this.x = x;
    }

    public VecN(VecN a, double ... b) {
        this.x = new double[a.x.length + b.length];
        System.arraycopy(a.x, 0, this.x, 0, a.x.length);
        System.arraycopy(b, 0, this.x, a.x.length, b.length);
    }

    public double sq() {
        return this.scale(this);
    }

    public double l() {
        return Math.sqrt(this.scale(this));
    }

    public boolean isNaN() {
        for (double a : this.x) {
            if (!Double.isNaN(a)) continue;
            return true;
        }
        return false;
    }

    public VecN copy() {
        VecN vec = new VecN(this.x.length);
        System.arraycopy(this.x, 0, vec.x, 0, this.x.length);
        return vec;
    }

    public VecN sub(int o, int n) {
        VecN vec = new VecN(n);
        System.arraycopy(this.x, o, vec.x, 0, n);
        return vec;
    }

    public VecN neg() {
        VecN vec = new VecN(this.x.length);
        for (int i = 0; i < this.x.length; ++i) {
            vec.x[i] = -this.x[i];
        }
        return vec;
    }

    public VecN norm() {
        double d = this.l();
        VecN vec = new VecN(this.x.length);
        for (int i = 0; i < this.x.length; ++i) {
            vec.x[i] = this.x[i] / d;
        }
        return vec;
    }

    public VecN add(double ... x) {
        VecN vec = new VecN(x.length);
        for (int i = 0; i < x.length; ++i) {
            vec.x[i] = this.x[i] + x[i];
        }
        return vec;
    }

    public VecN scale(double ... x) {
        VecN vec = new VecN(x.length);
        for (int i = 0; i < x.length; ++i) {
            vec.x[i] = this.x[i] * x[i];
        }
        return vec;
    }

    public VecN add(VecN a) {
        VecN vec = new VecN(a.x.length > this.x.length ? a.x.length : this.x.length);
        int n = a.x.length < this.x.length ? a.x.length : this.x.length;
        for (int i = 0; i < n; ++i) {
            vec.x[i] = this.x[i] + a.x[i];
        }
        return vec;
    }

    public VecN diff(VecN a) {
        VecN vec = new VecN(a.x.length > this.x.length ? a.x.length : this.x.length);
        int n = a.x.length < this.x.length ? a.x.length : this.x.length;
        for (int i = 0; i < n; ++i) {
            vec.x[i] = this.x[i] - a.x[i];
        }
        return vec;
    }

    public VecN scale(double s) {
        VecN vec = new VecN(this.x.length);
        for (int i = 0; i < this.x.length; ++i) {
            vec.x[i] = this.x[i] * s;
        }
        return vec;
    }

    public double scale(VecN a) {
        if (a.x.length != this.x.length) {
            throw new IllegalArgumentException("dot-product with Vectors of different dimensions");
        }
        double r = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            r += this.x[i] * a.x[i];
        }
        return r;
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        int[] v = new int[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            v[i] = Float.floatToRawIntBits((float)this.x[i]);
        }
        nbt.func_74783_a(name, v);
    }

    public static VecN readFromNBT(NBTTagCompound nbt, String name) {
        int[] v = nbt.func_74759_k(name);
        VecN vec = new VecN(v.length);
        for (int i = 0; i < vec.x.length; ++i) {
            vec.x[i] = Float.intBitsToFloat(v[i]);
        }
        return vec;
    }
}

