/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.lib.block.AdvancedBlock;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static final BlockPos NOWHERE = new BlockPos(0, -1, 0);
    public static final byte IN = -1;
    public static final byte OUT = 1;
    public static final byte ACC = 0;
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static void forRing(BlockPos center, EnumFacing.Axis axis, int radius, ObjIntConsumer<BlockPos> operation) {
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        switch (axis) {
            case X: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x, y - radius, z + i), d);
                    operation.accept(new BlockPos(x, y + radius, z - i), d);
                    operation.accept(new BlockPos(x, y - i, z - radius), d);
                    operation.accept(new BlockPos(x, y + i, z + radius), d);
                }
                break;
            }
            case Y: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x - radius, y, z + i), d);
                    operation.accept(new BlockPos(x + radius, y, z - i), d);
                    operation.accept(new BlockPos(x - i, y, z - radius), d);
                    operation.accept(new BlockPos(x + i, y, z + radius), d);
                }
                break;
            }
            case Z: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x - radius, y + i, z), d);
                    operation.accept(new BlockPos(x + radius, y - i, z), d);
                    operation.accept(new BlockPos(x - i, y - radius, z), d);
                    operation.accept(new BlockPos(x + i, y + radius, z), d);
                }
                break;
            }
        }
    }

    @Nullable
    public static TileEntity neighborTile(TileEntity tile, EnumFacing side) {
        BlockPos pos;
        World world = tile.func_145831_w();
        return world.func_175667_e(pos = tile.func_174877_v().func_177972_a(side)) ? world.func_175625_s(pos) : null;
    }

    @Nullable
    public static TileEntity getTileAt(World world, BlockPos pos) {
        return world.func_175667_e(pos) ? world.func_175625_s(pos) : null;
    }

    @Nullable
    public static <T> T neighborCapability(TileEntity tile, EnumFacing side, Capability<T> cap) {
        BlockPos pos;
        World world = tile.func_145831_w();
        if (!world.func_175667_e(pos = tile.func_174877_v().func_177972_a(side))) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return (T)(te != null ? te.getCapability(cap, side.func_176734_d()) : null);
    }

    @Nullable
    public static <T> T getCapabilityAt(World world, BlockPos pos, @Nullable EnumFacing side, Capability<T> cap) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return (T)(te != null ? te.getCapability(cap, side) : null);
    }

    public static boolean neighboursLoaded(World world, BlockPos pos) {
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        return (x == 0 ? world.func_175667_e(pos.func_177982_a(-1, 0, 0)) : x != 15 || world.func_175667_e(pos.func_177982_a(1, 0, 0))) && (z == 0 ? world.func_175667_e(pos.func_177982_a(0, 0, -1)) : z != 15 || world.func_175667_e(pos.func_177982_a(0, 0, 1)));
    }

    public static EnumFacing hitSide(float X, float Y, float Z) {
        float dz;
        float dx = Math.abs(X -= 0.5f);
        float dy = Math.abs(Y -= 0.5f);
        return dy > (dz = Math.abs(Z -= 0.5f)) && dy > dx ? (Y < 0.0f ? EnumFacing.DOWN : EnumFacing.UP) : (dz > dx ? (Z < 0.0f ? EnumFacing.NORTH : EnumFacing.SOUTH) : (X < 0.0f ? EnumFacing.WEST : EnumFacing.EAST));
    }

    public static RayTraceResult getHit(EntityPlayer player, IBlockState block, BlockPos pos) {
        Vec3d p = player.func_174824_e(1.0f);
        return block.func_185910_a(player.field_70170_p, pos, p, p.func_178787_e(player.func_70676_i(1.0f).func_186678_a(16.0)));
    }

    public static FluidStack getFluid(World world, BlockPos pos, boolean sourceOnly) {
        boolean source;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return null;
        }
        if (block instanceof IFluidBlock) {
            FluidStack fluid = ((IFluidBlock)block).drain(world, pos, false);
            if (!sourceOnly && fluid == null) {
                return new FluidStack(((IFluidBlock)block).getFluid(), 0);
            }
            return fluid;
        }
        boolean bl = source = state == block.func_176223_P();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.WATER, source ? 1000 : 0) : null;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.LAVA, source ? 1000 : 0) : null;
        }
        return null;
    }

    public static EnumFacing getLookDirStrict(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return EnumFacing.DOWN;
        }
        if (entity.field_70125_A > 45.0f) {
            return EnumFacing.UP;
        }
        return entity.func_174811_aO();
    }

    public static EnumFacing getLookDirPlacement(Entity entity) {
        if (entity.field_70125_A < -35.0f) {
            return EnumFacing.DOWN;
        }
        if (entity.field_70125_A > 40.0f) {
            return EnumFacing.UP;
        }
        return entity.func_174811_aO();
    }

    public static EnumFacing getSide(BlockPos pos, BlockPos ref) {
        int dx = pos.func_177958_n() - ref.func_177958_n();
        int dy = pos.func_177956_o() - ref.func_177956_o();
        int dz = pos.func_177952_p() - ref.func_177952_p();
        if (dx != 0) {
            if (dy != 0 || dz != 0) {
                return null;
            }
            return dx == -1 ? EnumFacing.WEST : (dx == 1 ? EnumFacing.EAST : null);
        }
        if (dy != 0) {
            if (dz != 0) {
                return null;
            }
            return dy == -1 ? EnumFacing.DOWN : (dy == 1 ? EnumFacing.UP : null);
        }
        return dz == -1 ? EnumFacing.NORTH : (dz == 1 ? EnumFacing.SOUTH : null);
    }

    public static int coord(BlockPos pos, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        return 0;
    }

    public static double coord(double x, double y, double z, EnumFacing d) {
        switch (d) {
            case DOWN: {
                return -y;
            }
            case UP: {
                return y;
            }
            case NORTH: {
                return -z;
            }
            case SOUTH: {
                return z;
            }
            case WEST: {
                return -x;
            }
            case EAST: {
                return x;
            }
        }
        return 0.0;
    }

    public static void updateRedstoneOnSide(TileEntity te, int value, EnumFacing side) {
        TileEntity cp = Utils.neighborTile(te, side);
        if (cp != null && cp instanceof IQuickRedstoneHandler) {
            ((IQuickRedstoneHandler)cp).onRedstoneStateChange(side.func_176734_d(), value, te);
        } else {
            te.func_145831_w().func_190524_a(te.func_174877_v().func_177972_a(side), te.func_145838_q(), te.func_174877_v());
        }
    }

    public static <T extends TileEntity> void updateRedstoneOnSide(T te, EnumFacing side) {
        TileEntity cp = Utils.neighborTile(te, side);
        if (cp instanceof IQuickRedstoneHandler) {
            ((IQuickRedstoneHandler)cp).onRedstoneStateChange(side.func_176734_d(), ((AdvancedBlock.IRedstoneTile)te).redstoneLevel(side, false), te);
        } else {
            te.func_145831_w().func_190524_a(te.func_174877_v().func_177972_a(side), te.func_145838_q(), te.func_174877_v());
        }
    }

    public static void notifyNeighborTile(TileEntity te, EnumFacing side) {
        if (side != null) {
            BlockPos pos = te.func_174877_v().func_177972_a(side);
            World world = te.func_145831_w();
            if (world == null) {
                return;
            }
            if (world.func_175667_e(pos)) {
                IBlockState state = world.func_180495_p(pos);
                state.func_177230_c().onNeighborChange((IBlockAccess)world, pos, te.func_174877_v());
            }
        } else {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                Utils.notifyNeighborTile(te, f);
            }
        }
    }

    public static int cycleState(int cfg, int i, int m, int r, boolean incr) {
        return cfg & ~(m << i) | ((cfg >> i & m) + (incr ? 1 : r - 1)) % r << i;
    }

    public static int setState(int cfg, int i, int m, int x) {
        return cfg & ~(m << i) | (x & m) << i;
    }

    public static long cycleState(long cfg, int i, long m, int r, boolean incr) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | (long)(((int)(cfg >> i & m) + (incr ? 1 : r - 1)) % r) << i;
    }

    public static long setState(long cfg, int i, long m, int x) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | ((long)x & m) << i;
    }

    public static <T> T[] init(T[] arr, T val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
        return arr;
    }

    public static <T> T[] init(T[] arr, IntFunction<T> val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val.apply(i);
        }
        return arr;
    }

    public static NBTTagList writeStringArray(String[] arr) {
        NBTTagList list = new NBTTagList();
        for (String s : arr) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        return list;
    }

    public static String[] readStringArray(NBTTagList list, String[] arr) {
        int l = list.func_74745_c();
        if (arr == null || arr.length < l) {
            arr = new String[l];
        }
        for (int i = 0; i < l; ++i) {
            arr[i] = list.func_150307_f(i);
        }
        return arr;
    }

    public static NBTBase readTag(ByteBuf data, byte tagId) {
        switch (tagId) {
            case 1: {
                return new NBTTagByte(data.readByte());
            }
            case 2: {
                return new NBTTagShort(data.readShort());
            }
            case 3: {
                return new NBTTagInt(data.readInt());
            }
            case 4: {
                return new NBTTagLong(data.readLong());
            }
            case 5: {
                return new NBTTagFloat(data.readFloat());
            }
            case 6: {
                return new NBTTagDouble(data.readDouble());
            }
            case 7: {
                int l = data.readInt();
                if (l > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l + " > " + data.readableBytes());
                }
                byte[] arr = new byte[l];
                data.readBytes(arr);
                return new NBTTagByteArray(arr);
            }
            case 11: {
                int l = data.readInt();
                if (l * 4 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 4 + " > " + data.readableBytes());
                }
                int[] arr = new int[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readInt();
                }
                return new NBTTagIntArray(arr);
            }
            case 12: {
                int l = data.readInt();
                if (l * 8 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 8 + " > " + data.readableBytes());
                }
                long[] arr = new long[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readLong();
                }
                return new NBTTagLongArray(arr);
            }
            case 8: {
                int l = data.readUnsignedShort();
                if (l * 2 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 2 + " > " + data.readableBytes());
                }
                byte[] arr = new byte[l];
                data.readBytes(arr);
                return new NBTTagString(new String(arr, UTF8));
            }
            case 9: {
                NBTTagList list = new NBTTagList();
                tagId = data.readByte();
                for (int l = data.readInt(); l > 0; --l) {
                    list.func_74742_a(Utils.readTag(data, tagId));
                }
                return list;
            }
        }
        return null;
    }

    public static void writeTag(ByteBuf data, NBTBase tag) {
        switch (tag.func_74732_a()) {
            case 1: {
                data.writeByte((int)((NBTTagByte)tag).func_150290_f());
                return;
            }
            case 2: {
                data.writeShort((int)((NBTTagShort)tag).func_150289_e());
                return;
            }
            case 3: {
                data.writeInt(((NBTTagInt)tag).func_150287_d());
                return;
            }
            case 4: {
                data.writeLong(((NBTTagLong)tag).func_150291_c());
                return;
            }
            case 5: {
                data.writeFloat(((NBTTagFloat)tag).func_150288_h());
                return;
            }
            case 6: {
                data.writeDouble(((NBTTagDouble)tag).func_150286_g());
                return;
            }
            case 7: {
                byte[] arr = ((NBTTagByteArray)tag).func_150292_c();
                data.writeInt(arr.length);
                data.writeBytes(arr);
                return;
            }
            case 11: {
                int[] arr = ((NBTTagIntArray)tag).func_150302_c();
                data.writeInt(arr.length);
                for (int v : arr) {
                    data.writeInt(v);
                }
                return;
            }
            case 8: {
                byte[] arr = ((NBTTagString)tag).func_150285_a_().getBytes(UTF8);
                data.writeShort(arr.length);
                data.writeBytes(arr);
                return;
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                data.writeByte(list.func_150303_d());
                data.writeInt(list.func_74745_c());
                for (NBTBase stag : list) {
                    Utils.writeTag(data, stag);
                }
                return;
            }
        }
    }

    public static class ItemType {
        public final ItemStack[] types;
        public final boolean meta;
        public final boolean nbt;
        public final int[] ores;

        public ItemType() {
            this.types = null;
            this.ores = null;
            this.meta = false;
            this.nbt = false;
        }

        public ItemType(ItemStack ... types) {
            this.types = types;
            this.ores = null;
            this.meta = true;
            this.nbt = true;
        }

        public ItemType(boolean meta, boolean nbt, boolean ore, ItemStack ... types) {
            this.types = types;
            this.meta = meta;
            this.nbt = nbt;
            if (ore) {
                HashSet<Integer> list = new HashSet<Integer>();
                for (int i = 0; i < types.length; ++i) {
                    for (int j : OreDictionary.getOreIDs((ItemStack)types[i])) {
                        list.add(j);
                    }
                }
                this.ores = new int[list.size()];
                int n = 0;
                Object object = list.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    this.ores[n++] = i;
                }
            } else {
                this.ores = null;
            }
        }

        public boolean matches(ItemStack item) {
            return this.getMatch(item) >= 0;
        }

        public int getMatch(ItemStack item) {
            if (item.func_190926_b()) {
                return -1;
            }
            if (this.types == null) {
                return -1;
            }
            for (int i = 0; i < this.types.length; ++i) {
                ItemStack type = this.types[i];
                if (item.func_77973_b() != type.func_77973_b() || this.meta && item.func_77952_i() != type.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
                return i;
            }
            if (this.ores == null) {
                return -1;
            }
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i = 0; i < this.ores.length; ++i) {
                    if (this.ores[i] != o) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

