/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ClassUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SecurityChecker {
    private static final Set<String> ANY = Collections.singleton("*");
    private final HashMap<String, Set<String>> whitelist = new HashMap();

    public SecurityChecker put(Class<?> c, String ... members) {
        String name = c.getName().replace('.', '/');
        Set<String> set = this.whitelist.get(name);
        if (set == null) {
            set = new HashSet<String>();
            this.whitelist.put(name, set);
        }
        for (String s : members) {
            set.add(s.replace('.', '/'));
        }
        return this;
    }

    public SecurityChecker putAll(Class<?> c) {
        String name = c.getName().replace('.', '/');
        this.whitelist.put(name, ANY);
        return this;
    }

    public void verify(byte[] c) throws SecurityException {
        ArrayList<String> violations = new ArrayList<String>();
        try {
            ByteBuffer b = ByteBuffer.wrap(c);
            b.position(8);
            int n = b.getShort() - 1;
            String[] utf8s = new String[n];
            int[] ref = new int[n];
            byte[] tags = new byte[n];
            for (int i = 0; i < n; ++i) {
                byte tag = b.get();
                if (tag == 1) {
                    byte[] arr = new byte[b.getShort()];
                    b.get(arr);
                    utf8s[i] = new String(arr, ClassUtils.UTF8);
                    continue;
                }
                int l = this.getLength(tag);
                if (l == 2) {
                    ref[i] = b.getShort();
                } else if (l == 4) {
                    ref[i] = b.getInt();
                } else if (l == 8) {
                    ref[i] = b.getInt();
                    ref[++i] = b.getInt();
                } else {
                    b.position(b.position() + l);
                }
                tags[i] = tag;
            }
            b.position(b.position() + 2);
            short tc = b.getShort();
            block7: for (int i = 0; i < n; ++i) {
                byte tag = tags[i];
                int e = ref[i];
                switch (tag) {
                    case 7: {
                        String s;
                        if (i + 1 == tc || (s = this.elementType(utf8s[e - 1])) == null || this.whitelist.containsKey(s)) continue block7;
                        violations.add(s);
                        continue block7;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        Set<String> set;
                        String s;
                        int e1 = e >>> 16;
                        if (e1 == tc || (set = this.whitelist.get(s = this.elementType(utf8s[ref[e1 - 1] - 1]))) == null || set == ANY) continue block7;
                        e = ref[(e & 0xFFFF) - 1];
                        String s1 = utf8s[(e >>> 16) - 1];
                        if (tag != 9) {
                            s1 = s1 + utf8s[(e & 0xFFFF) - 1];
                        }
                        if (set.contains(s1)) continue block7;
                        violations.add(s + "." + s1);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder("Runtime assembled code may potentially access the following illegal objects:\n");
            for (String s : violations) {
                sb.append(s).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            throw new SecurityException(sb.toString());
        }
    }

    private String elementType(String s) {
        char c = s.charAt(0);
        if (c != '[') {
            return s;
        }
        while ((c = (s = s.substring(1)).charAt(0)) == '[') {
        }
        if (c == 'L') {
            return s.substring(1, s.length() - 1);
        }
        return null;
    }

    private int getLength(byte tag) {
        switch (tag) {
            case 1: 
            case 7: 
            case 8: {
                return 2;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 4;
            }
            case 5: 
            case 6: {
                return 8;
            }
        }
        throw new IllegalArgumentException("unsupported tag id " + tag);
    }
}

