/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class SideRoom
extends MineshaftPiece {
    private boolean hasDownstairs;
    private static final int SECONDARY_AXIS_LEN = 10;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 9;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SideRoom() {
    }

    public SideRoom(int i, int pieceChainLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74757_a("hasDownstairs", this.hasDownstairs);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        this.hasDownstairs = tag.func_74767_n("hasDownstairs");
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 10, 5, 5, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        if (random.nextFloat() < Configuration.spawnRates.workstationDungeonSpawnRate) {
            EnumFacing direction = this.func_186165_e();
            if (direction == null) {
                return;
            }
            MineshaftPiece newDungeonPiece = null;
            switch (direction) {
                case NORTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78892_f, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case SOUTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case WEST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c + 6, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case EAST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c + 6, this.func_186165_e(), this.func_74877_c(), 0);
                }
            }
            if (newDungeonPiece != null) {
                this.hasDownstairs = true;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 9, 4)) {
            return false;
        }
        this.fill(world, box, random, 0, 0, 0, 9, 1, 4, this.getBrickSelector());
        this.replaceNonAir(world, box, random, 0, 2, 0, 9, 3, 4, this.getBrickSelector());
        this.fill(world, box, 1, 1, 1, 8, 3, 4, AIR);
        boolean[][] ceiling = new boolean[10][5];
        for (int x = 0; x <= 9; ++x) {
            for (int z = 0; z <= 4; ++z) {
                IBlockState currState = this.getBlockStateFromPosFixed(world, x, 4, z, box);
                if (currState == null || currState == AIR) continue;
                this.func_175811_a(world, this.getBrickSelector().get(random), x, 4, z, box);
                ceiling[x][z] = true;
            }
        }
        if (!this.hasDownstairs) {
            this.generateLegs(world, box, random);
        }
        if (random.nextInt(2) == 0) {
            this.func_175811_a(world, Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.NORTH), 2, 1, 1, box);
            TileEntity blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(2, 1), this.func_74862_a(1), this.func_74873_b(2, 1)));
            if (blockEntity instanceof TileEntityFurnace) {
                ((TileEntityFurnace)blockEntity).func_70299_a(1, new ItemStack(Items.field_151044_h, random.nextInt(33)));
            }
        }
        if (random.nextInt(2) == 0) {
            this.func_175811_a(world, Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.NORTH), 1, 1, 1, box);
            TileEntity blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(1, 1), this.func_74862_a(1), this.func_74873_b(1, 1)));
            if (blockEntity instanceof TileEntityFurnace) {
                ((TileEntityFurnace)blockEntity).func_70299_a(1, new ItemStack(Items.field_151044_h, random.nextInt(33)));
            }
        }
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150462_ai.func_176223_P(), 3, 1, 1, box);
        if (random.nextInt(4) == 0) {
            this.func_186167_a(world, box, random, 8, 1, 1, LootTableList.field_186424_f);
        }
        if (this.hasDownstairs) {
            this.func_175811_a(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.NORTH), 6, 0, 1, box);
            this.func_175811_a(world, this.getTrapdoor().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 6, 1, 1, box);
        }
        this.generateIronBarSupports(world, box, random, ceiling);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 9, 3, 4);
        this.addVines(world, box, random, 1, 0, 1, 8, 4, 3);
        return true;
    }

    private void generateLegs(World world, StructureBoundingBox box, Random random) {
        this.generateLeg(world, random, box, 1, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 1, 3, this.getBrickSelector());
        this.generateLeg(world, random, box, 8, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 8, 3, this.getBrickSelector());
    }

    private void generateIronBarSupports(World world, StructureBoundingBox box, Random random, boolean[][] ceiling) {
        LinkedList invalidXs = Lists.newLinkedList();
        for (int z = 2; z <= 3; ++z) {
            for (int x = 2; x <= 7; ++x) {
                if (invalidXs.contains(x) || !ceiling[x][z] || random.nextInt(5) != 0) continue;
                this.fill(world, box, x, 1, z, x, 3, z, Blocks.field_150411_aY.func_176223_P());
                invalidXs.add(x);
                ++x;
            }
        }
    }
}

