/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.launchwrapper;

import java.net.URL;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.core.platform.PlatformSide;

public class SideDetermination {
    private boolean hasBeenDetermined;
    private PlatformSide side;

    public void determine(ModDirector director) {
        director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/SideDetermination", "Launchwrapper", "Trying to determine side...", new Object[0]);
        URL minecraftMainClass = director.getClass().getClassLoader().getResource("net/minecraft/client/main/Main.class");
        if (minecraftMainClass != null) {
            director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/SideDetermination", "Launchwrapper", "Found minecraft client main class at %s, assuming we are running on a client!", minecraftMainClass.toExternalForm());
            this.side = PlatformSide.CLIENT;
        } else {
            director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/SideDetermination", "Launchwrapper", "Unable to find minecraft client main class, assuming we are running on a server!", new Object[0]);
            this.side = PlatformSide.SERVER;
        }
        this.hasBeenDetermined = true;
    }

    public PlatformSide get() {
        if (!this.hasBeenDetermined) {
            throw new IllegalStateException("Side has not been determined yet");
        }
        return this.side;
    }
}

