/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.ui.page;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.configuration.modpack.ModpackIconConfiguration;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.ui.ImageLoader;

public class ProgressPage
extends JPanel {
    public ProgressPage(ModpackConfiguration configuration, String title) {
        this.setLayout(new BoxLayout(this, 1));
        JLabel titleLabel = new JLabel(title, 0);
        titleLabel.setFont(new Font(titleLabel.getFont().getName(), 1, 20));
        titleLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, titleLabel.getMinimumSize().height));
        this.add(titleLabel);
        ModpackIconConfiguration icon = configuration.icon();
        if (icon != null) {
            JLabel iconLabel = ImageLoader.createLabelForImage(icon.path(), icon.width(), icon.height());
            iconLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, iconLabel.getMaximumSize().height));
            this.add(iconLabel);
        }
    }

    public ProgressCallback createProgressCallback(String title, String initialMessage) {
        return new VisualProgressCallback(title, initialMessage);
    }

    private class VisualProgressCallback
    implements ProgressCallback {
        private JProgressBar progressBar;
        private int currentStep;
        boolean done;

        private VisualProgressCallback(String title, String initialMessage) {
            SwingUtilities.invokeLater(() -> {
                this.progressBar = new JProgressBar();
                this.progressBar.setString(initialMessage);
                this.progressBar.setStringPainted(true);
                this.progressBar.setBorder(new TitledBorder(title));
                ProgressPage.this.add(this.progressBar);
                ProgressPage.this.revalidate();
            });
            this.done = false;
            this.setSteps(1);
        }

        @Override
        public void setSteps(int steps) {
            this.currentStep = 0;
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(steps * 100);
            });
        }

        @Override
        public void reportProgress(long current, long max) {
            int steppedPercent = (int)(current * 100L / max) + this.currentStep * 100;
            SwingUtilities.invokeLater(() -> this.progressBar.setValue(steppedPercent));
        }

        @Override
        public void message(String message) {
            SwingUtilities.invokeLater(() -> this.progressBar.setString(message));
        }

        @Override
        public void step() {
            ++this.currentStep;
            this.reportProgress(0L, 1L);
        }

        @Override
        public void done() {
            if (this.done) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                ProgressPage.this.remove(this.progressBar);
                ProgressPage.this.revalidate();
            });
            this.done = true;
        }

        @Override
        public void title(String newTitle) {
            SwingUtilities.invokeLater(() -> this.progressBar.setBorder(new TitledBorder(newTitle)));
        }

        @Override
        public void indeterminate(boolean isIndeterminate) {
            SwingUtilities.invokeLater(() -> this.progressBar.setIndeterminate(isIndeterminate));
        }
    }
}

