/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.ui;

import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.minecraftforge.fml.exit.QualifiedExit;

public class VersionMismatchDialog
extends JDialog {
    public VersionMismatchDialog(ModpackConfiguration configuration) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        JFrame frame = new JFrame(configuration.packName());
        JButton button = new JButton("Acknowledge");
        button.addActionListener(e -> {
            if (configuration.refuseLaunch()) {
                QualifiedExit.exit(0);
            }
            latch.countDown();
            frame.dispose();
        });
        String text = "Local and remote modpack versions are mismatching.";
        String textShutdown = text + " The game will now shut down!";
        JLabel label = new JLabel(configuration.refuseLaunch() ? this.asHtml(textShutdown) : this.asHtml(text), 0);
        frame.add((Component)label, "Center");
        frame.add((Component)button, "South");
        frame.setSize(330, 120);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
        latch.await();
    }

    private String asHtml(String content) {
        return "<html>" + content + "</html>";
    }
}

