/*
 * Decompiled with CFR 0.152.
 */
package insearchofname.com.spawnPlugin.commands;

import insearchofname.com.spawnPlugin.Msg;
import insearchofname.com.spawnPlugin.SpawnPlugin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Spawn
implements CommandExecutor {
    private static final Map<String, Location> playerLastLocation = new HashMap<String, Location>();

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (!(commandSender instanceof Player)) {
            Msg.send(commandSender, "&cYou must be a player to use this command!");
            return true;
        }
        Player player = (Player)commandSender;
        this.startTeleportTimer(player);
        return true;
    }

    private void storePlayerLocation(Player player) {
        playerLastLocation.put(player.getUniqueId().toString(), player.getLocation());
    }

    private void startTeleportTimer(final Player player) {
        final Location initialLocation = player.getLocation();
        String worldName = SpawnPlugin.getPlugin().getConfig().getString("spawn.world");
        double x = SpawnPlugin.getPlugin().getConfig().getDouble("spawn.x");
        double y = SpawnPlugin.getPlugin().getConfig().getDouble("spawn.y");
        double z = SpawnPlugin.getPlugin().getConfig().getDouble("spawn.z");
        if (worldName == null) {
            Msg.send((CommandSender)player, "&cNo spawn set! Please use '/setspawn' to set one.");
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        final Location customSpawnLocation = new Location(world, x, y, z);
        new BukkitRunnable(){
            int countdown = 5;

            public void run() {
                if (this.countdown <= 0) {
                    Spawn.this.storePlayerLocation(player);
                    player.teleport(customSpawnLocation);
                    Msg.send((CommandSender)player, "&aTeleported to spawn!");
                    this.cancel();
                    return;
                }
                if (!player.getLocation().equals((Object)initialLocation)) {
                    Msg.send((CommandSender)player, "&cYou moved, you silly guy...");
                    this.cancel();
                    return;
                }
                Msg.send((CommandSender)player, "&eTeleporting to spawn in: &9" + this.countdown + " seconds. &eDo not move!");
                --this.countdown;
            }
        }.runTaskTimer((Plugin)SpawnPlugin.getPlugin(), 0L, 20L);
    }

    public static Location getLastLocation(Player player) {
        return playerLastLocation.get(player.getUniqueId().toString());
    }

    public static void removeLastLocation(Player player) {
        playerLastLocation.remove(player.getUniqueId().toString());
    }
}

