/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class DigestUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String SHA_256 = "SHA-256";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private DigestUtils() {
        throw new AssertionError();
    }

    public static String encodeHexString(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return new String(out);
    }

    public static String sha256Hex(InputStream data) throws IOException {
        MessageDigest digest = DigestUtils.getSha256Digest();
        byte[] bytes = DigestUtils.updateDigest(digest, data).digest();
        return DigestUtils.encodeHexString(bytes);
    }

    public static String sha256Hex(String data) {
        return DigestUtils.encodeHexString(DigestUtils.sha256(data));
    }

    public static byte[] hmacSha256(byte[] key, String data) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, HMAC_SHA_256);
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            mac.init(keySpec);
            return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] sha256(String data) {
        return DigestUtils.getSha256Digest().digest(data.getBytes(StandardCharsets.UTF_8));
    }

    private static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance(SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static MessageDigest updateDigest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest;
    }
}

