/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.http.spi;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SdkHttpUtils {
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    private SdkHttpUtils() {
        throw new AssertionError();
    }

    public static String urlEncode(String value) {
        return SdkHttpUtils.urlEncode(value, false);
    }

    public static String urlEncodeIgnoreSlashes(String value) {
        return SdkHttpUtils.urlEncode(value, true);
    }

    public static String toQueryString(Map<String, List<String>> rawQueryParameters) {
        return rawQueryParameters.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(value -> SdkHttpUtils.urlEncode((String)entry.getKey()) + "=" + SdkHttpUtils.urlEncode(value)).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
    }

    private static String urlEncode(String value, boolean ignoreSlashes) {
        try {
            String encoded = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (ignoreSlashes && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        String pattern = Pattern.quote("+") + "|" + Pattern.quote("*") + "|" + Pattern.quote("%7E") + "|" + Pattern.quote("%2F");
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern);
    }
}

