/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.marshal;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import org.dynmap.s3lite.core.auth.SignableRequest;

final class MarshallerUtils {
    private static final String META_PREFIX = "x-amz-meta-";
    static final DateTimeFormatter RFC_1123_DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC);
    static final DateTimeFormatter ISO_INSTANT_FORMATTER = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC);

    private MarshallerUtils() {
        throw new AssertionError();
    }

    static void addParameterIfNotNull(SignableRequest request, String paramName, String paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, paramValue);
        }
    }

    static void addParameterIfNotNull(SignableRequest request, String paramName, Boolean paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, Boolean.toString(paramValue));
        }
    }

    static void addParameterIfNotNull(SignableRequest request, String paramName, Integer paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, Integer.toString(paramValue));
        }
    }

    static void addHeaderIfNotNull(SignableRequest request, String headerName, String headerValue) {
        if (headerValue != null) {
            request.addHeader(headerName, headerValue);
        }
    }

    static void addHeaderIfNotNull(SignableRequest request, String headerName, Boolean headerValue) {
        if (headerValue != null) {
            request.addHeader(headerName, Boolean.toString(headerValue));
        }
    }

    static void addHeaderIfNotNull(SignableRequest request, String headerName, Long headerValue) {
        if (headerValue != null) {
            request.addHeader(headerName, Long.toString(headerValue));
        }
    }

    static String formatIfNotNull(TemporalAccessor temporal, DateTimeFormatter formatter) {
        if (temporal == null) {
            return null;
        }
        return formatter.format(temporal);
    }

    static void addMetadata(SignableRequest signableRequest, Map<String, String> metadata) {
        metadata.forEach((key, value) -> signableRequest.addHeader(META_PREFIX + key, (String)value));
    }
}

