/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.response;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dynmap.s3lite.api.response.CommonPrefix;
import org.dynmap.s3lite.api.response.S3Object;

public class ListObjectsV2Response {
    private final String bucketName;
    private final List<CommonPrefix> commonPrefixes;
    private final List<S3Object> contents;
    private final String continuationToken;
    private final String delimiter;
    private final String encodingType;
    private final Boolean isTruncated;
    private final Integer keyCount;
    private final Integer maxKeys;
    private final String nextContinuationToken;
    private final String prefix;
    private final String startAfter;

    private ListObjectsV2Response(Builder builder) {
        this.bucketName = builder.bucketName;
        this.commonPrefixes = builder.commonPrefixes;
        this.contents = builder.contents;
        this.continuationToken = builder.continuationToken;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.isTruncated = builder.isTruncated;
        this.keyCount = builder.keyCount;
        this.maxKeys = builder.maxKeys;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.prefix = builder.prefix;
        this.startAfter = builder.startAfter;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<CommonPrefix> getCommonPrefixes() {
        return Collections.unmodifiableList(this.commonPrefixes);
    }

    public List<S3Object> getContents() {
        return this.contents;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public Integer getKeyCount() {
        return this.keyCount;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public String getNextContinuationToken() {
        return this.nextContinuationToken;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListObjectsV2Response that = (ListObjectsV2Response)obj;
        return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.commonPrefixes, that.commonPrefixes) && Objects.equals(this.contents, that.contents) && Objects.equals(this.continuationToken, that.continuationToken) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.encodingType, that.encodingType) && Objects.equals(this.isTruncated, that.isTruncated) && Objects.equals(this.keyCount, that.keyCount) && Objects.equals(this.maxKeys, that.maxKeys) && Objects.equals(this.nextContinuationToken, that.nextContinuationToken) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.startAfter, that.startAfter);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.commonPrefixes, this.contents, this.continuationToken, this.delimiter, this.encodingType, this.isTruncated, this.keyCount, this.maxKeys, this.nextContinuationToken, this.prefix, this.startAfter);
    }

    public String toString() {
        return "ListObjectsV2Response{bucketName='" + this.bucketName + '\'' + ", commonPrefixes=" + this.commonPrefixes + ", contents=" + this.contents + ", continuationToken='" + this.continuationToken + '\'' + ", delimiter='" + this.delimiter + '\'' + ", encodingType='" + this.encodingType + '\'' + ", isTruncated=" + this.isTruncated + ", keyCount=" + this.keyCount + ", maxKeys=" + this.maxKeys + ", nextContinuationToken='" + this.nextContinuationToken + '\'' + ", prefix='" + this.prefix + '\'' + ", startAfter='" + this.startAfter + '\'' + '}';
    }

    public static class Builder {
        private String bucketName;
        private List<CommonPrefix> commonPrefixes;
        private List<S3Object> contents;
        private String continuationToken;
        private String delimiter;
        private String encodingType;
        private Boolean isTruncated;
        private Integer keyCount;
        private Integer maxKeys;
        private String nextContinuationToken;
        private String prefix;
        private String startAfter;

        private Builder() {
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder commonPrefixes(List<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
            return this;
        }

        public Builder contents(List<S3Object> contents) {
            this.contents = contents;
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public Builder keyCount(Integer keyCount) {
            this.keyCount = keyCount;
            return this;
        }

        public Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public ListObjectsV2Response build() {
            return new ListObjectsV2Response(this);
        }
    }
}

