/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.ModelBlockModel;
import org.dynmap.modsupport.impl.BlockModelImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public class ModelBlockModelImpl
extends BlockModelImpl
implements ModelBlockModel {
    private ArrayList<ModelBlockImpl> boxes = new ArrayList();
    private static HashMap<BlockSide, String> fromBlockSide = new HashMap();

    public ModelBlockModelImpl(String blkname, ModModelDefinitionImpl mdf) {
        super(blkname, mdf);
    }

    @Override
    public String getLine() {
        String ids = this.getIDsAndMeta();
        if (ids == null) {
            return null;
        }
        String line = String.format("modellist:%s", ids);
        for (ModelBlockImpl mb : this.boxes) {
            line = line + String.format(Locale.US, ",box=%f/%f/%f", mb.from[0], mb.from[1], mb.from[2]);
            if (!mb.shade) {
                line = line + "/false";
            }
            line = line + String.format(Locale.US, ":%f/%f/%f", mb.to[0], mb.to[1], mb.to[2]);
            if (mb.xrot != 0.0 || mb.yrot != 0.0 || mb.zrot != 0.0) {
                line = line + String.format(Locale.US, "/%f/%f/%f", mb.xrot, mb.yrot, mb.zrot);
                if (mb.rotorigin != null) {
                    line = line + String.format(Locale.US, "/%f/%f/%f", mb.rotorigin[0], mb.rotorigin[1], mb.rotorigin[2]);
                }
            }
            for (BlockSide bs : fromBlockSide.keySet()) {
                String side = fromBlockSide.get((Object)bs);
                ModelSide mside = (ModelSide)mb.sides.get((Object)bs);
                if (mside == null) continue;
                String rval = side;
                switch (mside.rot) {
                    default: {
                        break;
                    }
                    case DEG90: {
                        rval = rval + "90";
                        break;
                    }
                    case DEG180: {
                        rval = rval + "180";
                        break;
                    }
                    case DEG270: {
                        rval = rval + "270";
                    }
                }
                if (mside.uv != null) {
                    line = line + String.format(Locale.US, ":%s/%d/%f/%f/%f/%f", rval, mside.textureid, mside.uv[0], mside.uv[1], mside.uv[2], mside.uv[3]);
                    continue;
                }
                line = line + String.format(":%s/%d", rval, mside.textureid);
            }
            if (mb.modrotx == 0 && mb.modroty == 0 && mb.modrotz == 0) continue;
            line = line + String.format(":R/%d/%d/%d", mb.modrotx, mb.modroty, mb.modrotz);
        }
        return line;
    }

    @Override
    public ModelBlockModel.ModelBlock addModelBlock(double[] from, double[] to, double xrot, double yrot, double zrot, boolean shade, double[] rotorigin, int modrotx, int modroty, int modrotz) {
        ModelBlockImpl mbi = new ModelBlockImpl();
        if (from != null) {
            ((ModelBlockImpl)mbi).from[0] = from[0];
            ((ModelBlockImpl)mbi).from[1] = from[1];
            ((ModelBlockImpl)mbi).from[2] = from[2];
        }
        if (to != null) {
            ((ModelBlockImpl)mbi).to[0] = to[0];
            ((ModelBlockImpl)mbi).to[1] = to[1];
            ((ModelBlockImpl)mbi).to[2] = to[2];
        }
        mbi.xrot = xrot;
        mbi.yrot = yrot;
        mbi.zrot = zrot;
        mbi.shade = shade;
        if (rotorigin != null) {
            ModelBlockImpl.access$902(mbi, Arrays.copyOf(rotorigin, 3));
        }
        mbi.modrotx = modrotx;
        mbi.modroty = modroty;
        mbi.modrotz = modrotz;
        this.boxes.add(mbi);
        return mbi;
    }

    static {
        fromBlockSide.put(BlockSide.TOP, "u");
        fromBlockSide.put(BlockSide.BOTTOM, "d");
        fromBlockSide.put(BlockSide.NORTH, "n");
        fromBlockSide.put(BlockSide.SOUTH, "s");
        fromBlockSide.put(BlockSide.WEST, "w");
        fromBlockSide.put(BlockSide.EAST, "e");
    }

    private static class ModelBlockImpl
    implements ModelBlockModel.ModelBlock {
        private HashMap<BlockSide, ModelSide> sides = new HashMap();
        private double[] from = new double[]{0.0, 0.0, 0.0};
        private double[] to = new double[]{16.0, 16.0, 16.0};
        private double xrot = 0.0;
        private double yrot = 0.0;
        private double zrot = 0.0;
        private boolean shade;
        private double[] rotorigin;
        private int modrotx = 0;
        private int modroty = 0;
        private int modrotz = 0;

        private ModelBlockImpl() {
        }

        @Override
        public void addBlockSide(BlockSide side, double[] uv, ModelBlockModel.SideRotation rot, int textureid, int tintidx) {
            ModelSide ms = new ModelSide();
            ms.textureid = textureid;
            if (uv != null) {
                ModelSide.access$102(ms, Arrays.copyOf(uv, uv.length));
            }
            if (rot != null) {
                ms.rot = rot;
            }
            if (side == BlockSide.FACE_0 || side == BlockSide.Y_MINUS) {
                side = BlockSide.BOTTOM;
            }
            if (side == BlockSide.FACE_1 || side == BlockSide.Y_PLUS) {
                side = BlockSide.TOP;
            }
            if (side == BlockSide.FACE_2 || side == BlockSide.Z_MINUS) {
                side = BlockSide.NORTH;
            }
            if (side == BlockSide.FACE_3 || side == BlockSide.Z_PLUS) {
                side = BlockSide.SOUTH;
            }
            if (side == BlockSide.FACE_4 || side == BlockSide.X_MINUS) {
                side = BlockSide.WEST;
            }
            if (side == BlockSide.FACE_5 || side == BlockSide.X_PLUS) {
                side = BlockSide.EAST;
            }
            this.sides.put(side, ms);
        }

        @Override
        public void addBlockSide(BlockSide side, double[] uv, ModelBlockModel.SideRotation rot, int textureid) {
            this.addBlockSide(side, uv, rot, textureid, -1);
        }

        static /* synthetic */ double[] access$902(ModelBlockImpl x0, double[] x1) {
            x0.rotorigin = x1;
            return x1;
        }
    }

    private static class ModelSide {
        private double[] uv;
        private ModelBlockModel.SideRotation rot;
        int textureid;

        private ModelSide() {
        }

        static /* synthetic */ double[] access$102(ModelSide x0, double[] x1) {
            x0.uv = x1;
            return x1;
        }
    }
}

