/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class StairStateRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private RenderPatch[][] stepmeshes = new RenderPatch[8][];
    private RenderPatch[][] step_3_4_meshes = new RenderPatch[8][];
    private RenderPatch[][] step_1_4_meshes = new RenderPatch[8][];
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};
    private static final int[] midx_by_facing = new int[]{3, 2, 1, 0};
    private static final int[] midx_by_facing_left = new int[]{1, 0, 2, 3};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            this.stepmeshes[i] = this.buildStepMeshes(rpf, i);
            this.step_1_4_meshes[i] = this.buildCornerStepMeshes(rpf, i);
            this.step_3_4_meshes[i] = this.buildIntCornerStepMeshes(rpf, i);
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 3;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        StairStateRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private RenderPatch[] buildStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 0.5);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildIntCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 3: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int idx = ctx.getBlockType().stateIndex;
        int shape = (idx >> 1) % 5;
        int half = idx / 10 % 2;
        int facing = idx / 20 % 4;
        RenderPatch[] rp = null;
        switch (shape) {
            case 0: {
                rp = this.stepmeshes[midx_by_facing[facing] + (1 - half) * 4];
                break;
            }
            case 1: {
                rp = this.step_3_4_meshes[midx_by_facing_left[facing] + (1 - half) * 4];
                break;
            }
            case 2: {
                rp = this.step_3_4_meshes[midx_by_facing[facing] + (1 - half) * 4];
                break;
            }
            case 3: {
                rp = this.step_1_4_meshes[midx_by_facing_left[facing] + (1 - half) * 4];
                break;
            }
            case 4: {
                rp = this.step_1_4_meshes[midx_by_facing[facing] + (1 - half) * 4];
            }
        }
        return rp;
    }

    @Override
    public boolean isOnlyBlockStateSensitive() {
        return true;
    }
}

