/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.DynIntHashMap;

public class FluidStateRenderer
extends CustomRenderer {
    private static final int PATCH_STILL = 0;
    private static final int PATCH_FLOWING = 1;
    private static final int[] still_patches = new int[]{0, 0, 1, 1, 1, 1};
    private static boolean didIinit = false;
    private static RenderPatch bottom = null;
    private static DynIntHashMap meshcache = null;
    private static DynIntHashMap fullculledcache = null;

    private static final void init(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        meshcache = new DynIntHashMap();
        for (int i = 0; i < 10; ++i) {
            list.clear();
            CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0 - (double)i / 9.0, 0.0, 1.0, still_patches);
            FluidStateRenderer.putCachedModel(9 - i, 9 - i, 9 - i, 9 - i, list.toArray(new RenderPatch[list.size()]));
        }
        bottom = rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0);
        fullculledcache = new DynIntHashMap();
        RenderPatch[] fullblkmodel = FluidStateRenderer.getCachedModel(9, 9, 9, 9);
        for (int i = 0; i < 64; ++i) {
            list.clear();
            for (int f = 0; f < 6; ++f) {
                if ((i & 1 << f) == 0) continue;
                list.add(fullblkmodel[f]);
            }
            fullculledcache.put(i, list.toArray(new RenderPatch[list.size()]));
        }
    }

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        if (!didIinit) {
            FluidStateRenderer.init(rpf);
            didIinit = true;
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 2;
    }

    private static final DynmapBlockState getFluidState(MapDataContext ctx, int dx, int dy, int dz) {
        DynmapBlockState bs = dx == 0 && dy == 0 && dz == 0 ? ctx.getBlockType() : ctx.getBlockTypeAt(dx, dy, dz);
        DynmapBlockState fbs = bs.getLiquidState();
        return fbs != null ? fbs : bs;
    }

    private static final int getAirHeight(DynmapBlockState bs) {
        int idx = bs.stateIndex;
        return idx > 7 ? 1 : idx + 1;
    }

    private static final int getIntKey(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1) {
        return h_1_1 + (h_n1_1 << 4) + (h_1_n1 << 8) + (h_n1_n1 << 12);
    }

    private static RenderPatch[] getCachedModel(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1) {
        return (RenderPatch[])meshcache.get(FluidStateRenderer.getIntKey(h_1_1, h_n1_1, h_1_n1, h_n1_n1));
    }

    private static void putCachedModel(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1, RenderPatch[] model) {
        meshcache.put(FluidStateRenderer.getIntKey(h_1_1, h_n1_1, h_1_n1, h_n1_n1), model);
    }

    private static final RenderPatch[] getFullCulledModel(MapDataContext ctx, DynmapBlockState bs_0_0_0, DynmapBlockState bs_0_1_0) {
        DynmapBlockState bs_n1_0_0 = FluidStateRenderer.getFluidState(ctx, -1, 0, 0);
        DynmapBlockState bs_1_0_0 = FluidStateRenderer.getFluidState(ctx, 1, 0, 0);
        DynmapBlockState bs_0_0_n1 = FluidStateRenderer.getFluidState(ctx, 0, 0, -1);
        DynmapBlockState bs_0_0_1 = FluidStateRenderer.getFluidState(ctx, 0, 0, 1);
        return FluidStateRenderer.getFullCulledModel(ctx, bs_0_0_0, bs_0_1_0, bs_n1_0_0, bs_1_0_0, bs_0_0_n1, bs_0_0_1);
    }

    private static final RenderPatch[] getFullCulledModel(MapDataContext ctx, DynmapBlockState bs_0_0_0, DynmapBlockState bs_0_1_0, DynmapBlockState bs_n1_0_0, DynmapBlockState bs_1_0_0, DynmapBlockState bs_0_0_n1, DynmapBlockState bs_0_0_1) {
        int idx = 0;
        if (!bs_0_0_0.matchingBaseState(FluidStateRenderer.getFluidState(ctx, 0, -1, 0))) {
            ++idx;
        }
        if (!bs_0_0_0.matchingBaseState(bs_0_1_0)) {
            idx += 2;
        }
        if (!bs_0_0_0.matchingBaseState(bs_n1_0_0)) {
            idx += 4;
        }
        if (!bs_0_0_0.matchingBaseState(bs_1_0_0)) {
            idx += 8;
        }
        if (!bs_0_0_0.matchingBaseState(bs_0_0_n1)) {
            idx += 16;
        }
        if (!bs_0_0_0.matchingBaseState(bs_0_0_1)) {
            idx += 32;
        }
        return (RenderPatch[])fullculledcache.get(idx);
    }

    private static final boolean isUpperCornerHeightFull(DynmapBlockState b0, DynmapBlockState u0, DynmapBlockState u1, DynmapBlockState u2, DynmapBlockState u3) {
        return b0.matchingBaseState(u0) || b0.matchingBaseState(u1) || b0.matchingBaseState(u2) || b0.matchingBaseState(u3);
    }

    private static final int getCornerHeight(DynmapBlockState b0, DynmapBlockState b1, DynmapBlockState b2, DynmapBlockState b3) {
        int accum = 0;
        int cnt = 0;
        int h = FluidStateRenderer.getAirHeight(b0);
        if (h == 1) {
            accum += 11 * h;
            cnt += 11;
        } else {
            accum += h;
            ++cnt;
        }
        if (b1.matchingBaseState(b0)) {
            h = FluidStateRenderer.getAirHeight(b1);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b1.isSolid()) {
            accum += 9;
            ++cnt;
        }
        if (b2.matchingBaseState(b0)) {
            h = FluidStateRenderer.getAirHeight(b2);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b2.isSolid()) {
            accum += 9;
            ++cnt;
        }
        if (b3.matchingBaseState(b0)) {
            h = FluidStateRenderer.getAirHeight(b3);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b3.isSolid()) {
            accum += 9;
            ++cnt;
        }
        return 9 - (accum + cnt / 2) / cnt;
    }

    @Override
    public final RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int bh_n1_n1;
        DynmapBlockState bs_0_0_0 = FluidStateRenderer.getFluidState(ctx, 0, 0, 0);
        DynmapBlockState bs_0_1_0 = FluidStateRenderer.getFluidState(ctx, 0, 1, 0);
        if (bs_0_1_0.matchingBaseState(bs_0_0_0)) {
            return FluidStateRenderer.getFullCulledModel(ctx, bs_0_0_0, bs_0_1_0);
        }
        DynmapBlockState bs_0_1_1 = FluidStateRenderer.getFluidState(ctx, 0, 1, 1);
        DynmapBlockState bs_1_1_0 = FluidStateRenderer.getFluidState(ctx, 1, 1, 0);
        DynmapBlockState bs_1_1_1 = FluidStateRenderer.getFluidState(ctx, 1, 1, 1);
        DynmapBlockState bs_0_1_n1 = FluidStateRenderer.getFluidState(ctx, 0, 1, -1);
        DynmapBlockState bs_n1_1_0 = FluidStateRenderer.getFluidState(ctx, -1, 1, 0);
        DynmapBlockState bs_n1_1_n1 = FluidStateRenderer.getFluidState(ctx, -1, 1, -1);
        DynmapBlockState bs_1_1_n1 = FluidStateRenderer.getFluidState(ctx, 1, 1, -1);
        DynmapBlockState bs_n1_1_1 = FluidStateRenderer.getFluidState(ctx, -1, 1, 1);
        boolean isfull_1_1 = FluidStateRenderer.isUpperCornerHeightFull(bs_0_0_0, bs_0_1_0, bs_1_1_0, bs_0_1_1, bs_1_1_1);
        boolean isfull_1_n1 = FluidStateRenderer.isUpperCornerHeightFull(bs_0_0_0, bs_0_1_0, bs_1_1_0, bs_0_1_n1, bs_1_1_n1);
        boolean isfull_n1_1 = FluidStateRenderer.isUpperCornerHeightFull(bs_0_0_0, bs_0_1_0, bs_n1_1_0, bs_0_1_1, bs_n1_1_1);
        boolean isfull_n1_n1 = FluidStateRenderer.isUpperCornerHeightFull(bs_0_0_0, bs_0_1_0, bs_n1_1_0, bs_0_1_n1, bs_n1_1_n1);
        if (isfull_1_1 && isfull_1_n1 && isfull_n1_1 && isfull_n1_n1) {
            return FluidStateRenderer.getFullCulledModel(ctx, bs_0_0_0, bs_0_1_0);
        }
        DynmapBlockState bs_0_0_1 = FluidStateRenderer.getFluidState(ctx, 0, 0, 1);
        DynmapBlockState bs_1_0_0 = FluidStateRenderer.getFluidState(ctx, 1, 0, 0);
        DynmapBlockState bs_1_0_1 = FluidStateRenderer.getFluidState(ctx, 1, 0, 1);
        DynmapBlockState bs_0_0_n1 = FluidStateRenderer.getFluidState(ctx, 0, 0, -1);
        DynmapBlockState bs_n1_0_0 = FluidStateRenderer.getFluidState(ctx, -1, 0, 0);
        DynmapBlockState bs_n1_0_n1 = FluidStateRenderer.getFluidState(ctx, -1, 0, -1);
        DynmapBlockState bs_1_0_n1 = FluidStateRenderer.getFluidState(ctx, 1, 0, -1);
        DynmapBlockState bs_n1_0_1 = FluidStateRenderer.getFluidState(ctx, -1, 0, 1);
        int bh_1_1 = isfull_1_1 ? 9 : FluidStateRenderer.getCornerHeight(bs_0_0_0, bs_0_0_1, bs_1_0_0, bs_1_0_1);
        int bh_1_n1 = isfull_1_n1 ? 9 : FluidStateRenderer.getCornerHeight(bs_0_0_0, bs_0_0_n1, bs_1_0_0, bs_1_0_n1);
        int bh_n1_1 = isfull_n1_1 ? 9 : FluidStateRenderer.getCornerHeight(bs_0_0_0, bs_0_0_1, bs_n1_0_0, bs_n1_0_1);
        int n = bh_n1_n1 = isfull_n1_n1 ? 9 : FluidStateRenderer.getCornerHeight(bs_0_0_0, bs_0_0_n1, bs_n1_0_0, bs_n1_0_n1);
        if (bh_1_1 == 9 && bh_1_n1 == 9 && bh_n1_1 == 9 && bh_n1_n1 == 9) {
            return FluidStateRenderer.getFullCulledModel(ctx, bs_0_0_0, bs_0_1_0, bs_n1_0_0, bs_1_0_0, bs_0_0_n1, bs_0_0_1);
        }
        RenderPatch[] mod = FluidStateRenderer.getCachedModel(bh_1_1, bh_n1_1, bh_1_n1, bh_n1_n1);
        if (mod == null) {
            RenderPatchFactory rpf = ctx.getPatchFactory();
            ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
            list.add(bottom);
            FluidStateRenderer.addSide(list, rpf, 0.0, 0.0, 0.0, 1.0, bh_n1_n1, bh_n1_1);
            FluidStateRenderer.addSide(list, rpf, 1.0, 1.0, 1.0, 0.0, bh_1_1, bh_1_n1);
            FluidStateRenderer.addSide(list, rpf, 1.0, 0.0, 0.0, 0.0, bh_1_n1, bh_n1_n1);
            FluidStateRenderer.addSide(list, rpf, 0.0, 1.0, 1.0, 1.0, bh_n1_1, bh_1_1);
            int edge_xm = bh_n1_n1 + bh_n1_1;
            int edge_xp = bh_1_n1 + bh_1_1;
            int edge_zm = bh_n1_n1 + bh_1_n1;
            int edge_zp = bh_1_1 + bh_n1_1;
            if (edge_xp <= edge_xm && edge_xp <= edge_zm && edge_xp <= edge_zp) {
                FluidStateRenderer.addTop(list, rpf, 1.0, 1.0, 1.0, 0.0, bh_1_1, bh_1_n1, bh_n1_1, bh_n1_n1);
            } else if (edge_zp <= edge_zm && edge_zp <= edge_xm && edge_zp <= edge_xp) {
                FluidStateRenderer.addTop(list, rpf, 0.0, 1.0, 1.0, 1.0, bh_n1_1, bh_1_1, bh_n1_n1, bh_1_n1);
            } else if (edge_xm <= edge_xp && edge_xm <= edge_zm && edge_xm <= edge_zp) {
                FluidStateRenderer.addTop(list, rpf, 0.0, 0.0, 0.0, 1.0, bh_n1_n1, bh_n1_1, bh_1_n1, bh_1_1);
            } else {
                FluidStateRenderer.addTop(list, rpf, 1.0, 0.0, 0.0, 0.0, bh_1_n1, bh_n1_n1, bh_1_1, bh_n1_1);
            }
            mod = list.toArray(new RenderPatch[list.size()]);
            FluidStateRenderer.putCachedModel(bh_1_1, bh_n1_1, bh_1_n1, bh_n1_n1, mod);
        }
        return mod;
    }

    private static final void addSide(ArrayList<RenderPatch> list, RenderPatchFactory rpf, double x0, double z0, double x1, double z1, int h0, int h1) {
        if (h0 == 0 && h1 == 0) {
            return;
        }
        list.add(rpf.getPatch(x0, 0.0, z0, x1, 0.0, z1, x0, 1.0, z0, 0.0, 1.0, 0.0, 0.0, (double)h0 / 9.0, (double)h1 / 9.0, RenderPatchFactory.SideVisible.TOP, 1));
    }

    private static final void addTop(ArrayList<RenderPatch> list, RenderPatchFactory rpf, double x0, double z0, double x1, double z1, int h0, int h1, int h2, int h3) {
        int h0_upper = h1 + h2 - h3;
        if (x0 == x1) {
            if (h0_upper == h0) {
                list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
            } else {
                list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 1));
                list.add(rpf.getPatch(x0, (double)h0_upper / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
            }
        } else if (h0_upper == h0) {
            list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
        } else {
            list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 1));
            list.add(rpf.getPatch(x0, (double)h0_upper / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
        }
    }
}

