/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.DynmapBlockState;

public class HDBlockStateTextureMap {
    private static HDBlockStateTextureMap[] texmaps = new HDBlockStateTextureMap[DynmapBlockState.getGlobalIndexMax()];
    int[] faces;
    final byte[] layers;
    private final String blockset;
    final int colorMult;
    final CustomColorMultiplier custColorMult;
    final boolean stdrotate;
    private final Integer colorMapping;
    final TexturePack.BlockTransparency trans;
    public static final HDBlockStateTextureMap BLANK = new HDBlockStateTextureMap();

    HDBlockStateTextureMap() {
        this.blockset = null;
        this.colorMult = 0;
        this.custColorMult = null;
        this.faces = new int[]{-1, -1, -1, -1, -1, -1};
        this.layers = null;
        this.stdrotate = true;
        this.colorMapping = null;
        this.trans = TexturePack.BlockTransparency.TRANSPARENT;
    }

    public HDBlockStateTextureMap(int[] faces, byte[] layers, int colorMult, CustomColorMultiplier custColorMult, String blockset, boolean stdrot, Integer colorIndex, TexturePack.BlockTransparency trans) {
        this.faces = faces;
        this.layers = layers;
        this.colorMult = colorMult;
        this.custColorMult = custColorMult;
        this.blockset = blockset;
        this.stdrotate = stdrot;
        this.colorMapping = colorIndex;
        this.trans = trans;
    }

    public HDBlockStateTextureMap(HDBlockStateTextureMap map, TexturePack.BlockTransparency bt) {
        this.faces = map.faces;
        this.layers = map.layers;
        this.blockset = map.blockset;
        this.colorMult = map.colorMult;
        this.custColorMult = map.custColorMult;
        this.stdrotate = map.stdrotate;
        this.colorMapping = map.colorMapping;
        this.trans = bt != null ? bt : map.trans;
    }

    public int getIndexForFace(int face) {
        if (this.faces != null && this.faces.length > face) {
            return this.faces[face];
        }
        return -1;
    }

    public void resizeFaces(int cnt) {
        int[] newfaces = new int[cnt];
        System.arraycopy(this.faces, 0, newfaces, 0, this.faces.length);
        for (int i = this.faces.length; i < cnt; ++i) {
            newfaces[i] = -1;
        }
        this.faces = newfaces;
    }

    public void addToTable(Map<DynmapBlockState, BitSet> states, int lineNum) {
        for (DynmapBlockState baseblk : states.keySet()) {
            if (baseblk.isNotAir()) {
                BitSet stateidx = states.get(baseblk);
                int stateid = stateidx.nextSetBit(0);
                while (stateid >= 0) {
                    DynmapBlockState bs = baseblk.getState(stateid);
                    if (bs.isAir()) {
                        Log.warning("Invalid texture block state: " + baseblk.blockName + ":" + stateid);
                    } else {
                        if (this.blockset != null && !this.blockset.equals("core")) {
                            HDBlockModels.resetIfNotBlockSet(bs, this.blockset);
                        }
                        HDBlockStateTextureMap.copyToStateIndex(bs, this, null);
                    }
                    stateid = stateidx.nextSetBit(stateid + 1);
                }
                continue;
            }
            Log.warning("Invalid texture block name: " + baseblk.blockName + (lineNum > 0 ? "(line " + lineNum + ")" : ""));
        }
    }

    private static final void resize(int newend) {
        if (newend < texmaps.length) {
            return;
        }
        Object[] newm = new HDBlockStateTextureMap[newend + 1];
        System.arraycopy(texmaps, 0, newm, 0, texmaps.length);
        Arrays.fill(newm, texmaps.length, newm.length, BLANK);
        texmaps = newm;
    }

    public static void initializeTable() {
        Arrays.fill(texmaps, BLANK);
    }

    public static final HDBlockStateTextureMap getByBlockState(DynmapBlockState blk) {
        HDBlockStateTextureMap m = BLANK;
        try {
            m = texmaps[blk.globalStateIndex];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            HDBlockStateTextureMap.resize(blk.globalStateIndex);
        }
        return m;
    }

    public static void copyToStateIndex(DynmapBlockState blk, HDBlockStateTextureMap map, TexturePack.BlockTransparency trans) {
        HDBlockStateTextureMap.resize(blk.globalStateIndex);
        if (trans == null) {
            trans = map.trans;
        }
        if (trans == TexturePack.BlockTransparency.TRANSPARENT && blk.isWaterlogged()) {
            trans = TexturePack.BlockTransparency.SEMITRANSPARENT;
        }
        HDBlockStateTextureMap.texmaps[blk.globalStateIndex] = new HDBlockStateTextureMap(map, trans);
    }

    public static void remapTexture(String dest, String src) {
        DynmapBlockState dblk = DynmapBlockState.getBaseStateByName(dest);
        DynmapBlockState sblk = DynmapBlockState.getBaseStateByName(src);
        int scnt = sblk.getStateCount();
        for (int i = 0; i < dblk.getStateCount(); ++i) {
            int didx = dblk.getState((int)i).globalStateIndex;
            int sidx = sblk.getState((int)(i % scnt)).globalStateIndex;
            HDBlockStateTextureMap.texmaps[didx] = new HDBlockStateTextureMap(texmaps[sidx], null);
        }
    }

    public static HDBlockStateTextureMap getByGlobalIndex(int gidx) {
        HDBlockStateTextureMap m = BLANK;
        try {
            m = texmaps[gidx];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            HDBlockStateTextureMap.resize(gidx);
        }
        return m;
    }

    public final HDBlockStateTextureMap getStateMap(DynmapBlockState blk, int stateid) {
        return HDBlockStateTextureMap.getByGlobalIndex(blk.getState((int)stateid).globalStateIndex);
    }

    public static TexturePack.BlockTransparency getTransparency(DynmapBlockState blk) {
        TexturePack.BlockTransparency trans = TexturePack.BlockTransparency.OPAQUE;
        try {
            trans = HDBlockStateTextureMap.texmaps[blk.globalStateIndex].trans;
        }
        catch (ArrayIndexOutOfBoundsException x) {
            HDBlockStateTextureMap.resize(blk.globalStateIndex);
        }
        return trans;
    }

    public static TexturePack.ColorizingData getColorizingData() {
        TexturePack.ColorizingData map = new TexturePack.ColorizingData();
        for (int j = 0; j < texmaps.length; ++j) {
            if (HDBlockStateTextureMap.texmaps[j].colorMapping == null) continue;
            map.setBlkStateValue(DynmapBlockState.getStateByGlobalIndex(j), HDBlockStateTextureMap.texmaps[j].colorMapping);
        }
        return map;
    }
}

