/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.permissions;

import java.util.HashSet;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.dynmap.Log;
import org.dynmap.bukkit.DynmapPlugin;
import org.dynmap.bukkit.permissions.PermissionProvider;

public class VaultPermissions
implements PermissionProvider,
Listener {
    private RegisteredServiceProvider<Permission> permissionProvider;
    private final String prefix;

    public static VaultPermissions create(DynmapPlugin plugin, String name) {
        try {
            Class.forName("net.milkbowl.vault.permission.Permission");
        }
        catch (ClassNotFoundException cnfx) {
            return null;
        }
        RegisteredServiceProvider provider = plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (provider == null || provider.getProvider() == null) {
            return null;
        }
        Log.info("Using Vault provider " + ((Permission)provider.getProvider()).getName() + " for access control");
        VaultPermissions ret = new VaultPermissions(name, (RegisteredServiceProvider<Permission>)provider);
        plugin.getServer().getPluginManager().registerEvents((Listener)ret, (Plugin)plugin);
        return ret;
    }

    private VaultPermissions(String prefix, RegisteredServiceProvider<Permission> initialProvider) {
        this.prefix = prefix;
        this.permissionProvider = initialProvider;
    }

    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        RegisteredServiceProvider newProvider;
        if (event.getProvider().getService().equals(Permission.class) && (newProvider = event.getProvider()) != this.permissionProvider && newProvider.getPriority().compareTo((Enum)this.permissionProvider.getPriority()) >= 0) {
            this.permissionProvider = newProvider;
            Log.info("Using Vault provider " + ((Permission)this.permissionProvider.getProvider()).getName() + " for access control");
        }
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        return ((Permission)this.permissionProvider.getProvider()).has(sender, this.processPermission(permission));
    }

    @Override
    public Set<String> hasOfflinePermissions(String playerName, Set<String> perms) {
        Permission vault = (Permission)this.permissionProvider.getProvider();
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        HashSet<String> hasperms = new HashSet<String>();
        for (String perm : perms) {
            if (!vault.playerHas(null, player, this.processPermission(perm))) continue;
            hasperms.add(perm);
        }
        return hasperms;
    }

    @Override
    public boolean hasOfflinePermission(String playerName, String perm) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return ((Permission)this.permissionProvider.getProvider()).playerHas(null, player, this.processPermission(perm));
    }

    private String processPermission(String perm) {
        return this.prefix + "." + perm;
    }
}

