/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitMaterial;
import org.dynmap.bukkit.helper.BukkitVersionHelperGeneric;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.utils.Polygon;

public class BukkitVersionHelperCB
extends BukkitVersionHelperGeneric {
    private Class<?> nmsblock;
    private Class<?> nmsblockarray;
    private Class<?> nmsmaterial;
    private Class<?> longset;
    private Field blockbyid;
    private Field material;
    private Method material_issolid;
    private Method material_isliquid;
    private Method blockbyidfunc;
    private Method getworldborder;
    private Class<?> nmsworldborder;
    private Method worldborderminx;
    private Method worldbordermaxx;
    private Method worldborderminz;
    private Method worldbordermaxz;
    private Method getbiomebyid;
    private Method getbiomefunc;
    private Method getidbybiome;
    private Method getbycombinedid;
    private boolean isBadUnload = false;
    protected Object[] biomelist = null;

    public BukkitVersionHelperCB() {
        String bukkitver = Bukkit.getServer().getVersion();
        String mcver = "1.0.0";
        int idx = bukkitver.indexOf("(MC: ");
        if (idx > 0 && (idx = (mcver = bukkitver.substring(idx + 5)).indexOf(")")) > 0) {
            mcver = mcver.substring(0, idx);
        }
        this.isBadUnload = HDBlockModels.checkVersionRange(mcver, "1.9-");
        Log.verboseinfo("MCVER=" + mcver + ", isBadUnload=" + this.isBadUnload);
    }

    @Override
    public boolean isUnsafeAsync() {
        return true;
    }

    @Override
    protected String getNMSPackage() {
        Server srv = Bukkit.getServer();
        try {
            Method m = srv.getClass().getMethod("getHandle", new Class[0]);
            Object scm = m.invoke((Object)srv, new Object[0]);
            return scm.getClass().getPackage().getName();
        }
        catch (Exception x) {
            Log.severe("Error finding net.minecraft.server packages");
            return null;
        }
    }

    @Override
    protected void loadNMS() {
        this.nmsblock = this.getNMSClass("net.minecraft.server.Block");
        this.nmsblockarray = this.getNMSClass("[Lnet.minecraft.server.Block;");
        if (this.isBlockMaterialNeeded()) {
            this.nmsmaterial = this.getNMSClass("net.minecraft.server.Material");
            if (this.isBlockIdNeeded()) {
                this.blockbyid = this.getFieldNoFail(this.nmsblock, new String[]{"byId"}, this.nmsblockarray);
                if (this.blockbyid == null) {
                    this.blockbyidfunc = this.getMethod(this.nmsblock, new String[]{"getById", "e"}, new Class[]{Integer.TYPE});
                }
            }
            this.material = this.getPrivateField(this.nmsblock, new String[]{"material"}, this.nmsmaterial);
            this.getbycombinedid = this.getMethod(this.nmsblock, new String[]{"getByCombinedId"}, new Class[]{Integer.TYPE});
            this.material_issolid = this.getMethod(this.nmsmaterial, new String[]{"isSolid"}, nulltypes);
            this.material_isliquid = this.getMethod(this.nmsmaterial, new String[]{"isLiquid"}, nulltypes);
        }
        if (this.isBiomeBaseListNeeded()) {
            this.biomebase = this.getNMSClass("net.minecraft.server.BiomeBase");
            this.biomebasearray = this.getNMSClass("[Lnet.minecraft.server.BiomeBase;");
            this.biomebaselist = this.getPrivateFieldNoFail(this.biomebase, new String[]{"biomes"}, this.biomebasearray);
            if (this.biomebaselist == null) {
                this.getbiomefunc = this.getMethodNoFail(this.biomebase, new String[]{"getBiome"}, new Class[]{Integer.TYPE, this.biomebase});
                if (this.getbiomefunc == null) {
                    this.getbiomebyid = this.getMethod(this.biomebase, new String[]{"a"}, new Class[]{Integer.TYPE});
                }
            }
            this.biomebasetempfunc = this.getMethodNoFail(this.biomebase, new String[]{"getTemperature"}, nulltypes);
            if (this.biomebasetempfunc == null) {
                this.biomebasetemp = this.getPrivateFieldNoFail(this.biomebase, new String[]{"B"}, Float.TYPE);
                if (this.biomebasetemp != null) {
                    this.biomebasehumi = this.getPrivateField(this.biomebase, new String[]{"C"}, Float.TYPE);
                } else {
                    this.biomebasetemp = this.getPrivateField(this.biomebase, new String[]{"temperature", "F", "C", "aO"}, Float.TYPE);
                    this.biomebasehumi = this.getPrivateField(this.biomebase, new String[]{"humidity", "G", "D", "aP"}, Float.TYPE);
                }
            } else {
                this.biomebasehumifunc = this.getMethod(this.biomebase, new String[]{"getHumidity"}, nulltypes);
            }
            this.biomebaseidstring = this.getPrivateField(this.biomebase, new String[]{"y", "af", "ah", "z", "aS", "aR", "f"}, String.class);
            this.biomebaseid = this.getFieldNoFail(this.biomebase, new String[]{"id"}, Integer.TYPE);
            if (this.biomebaseid == null) {
                this.getidbybiome = this.getMethod(this.biomebase, new String[]{"a"}, new Class[]{this.biomebase});
            }
        }
        this.nmsworld = this.getNMSClass("net.minecraft.server.WorldServer");
        this.chunkprovserver = this.getNMSClass("net.minecraft.server.ChunkProviderServer");
        this.nmsw_chunkproviderserver = this.getPrivateFieldNoFail(this.nmsworld, new String[]{"chunkProviderServer"}, this.chunkprovserver);
        if (this.nmsw_chunkproviderserver == null) {
            Class<?> nmsworldbase = this.getNMSClass("net.minecraft.server.World");
            Class<?> nmsichunkprovider = this.getNMSClass("net.minecraft.server.IChunkProvider");
            this.nmsw_chunkproviderserver = this.getPrivateField(nmsworldbase, new String[]{"chunkProvider"}, nmsichunkprovider);
        }
        this.getworldborder = this.getMethodNoFail(this.nmsworld, new String[]{"af"}, nulltypes);
        this.longhashset = this.getOBCClassNoFail("org.bukkit.craftbukkit.util.LongHashSet");
        if (this.longhashset != null) {
            this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"contains"}, new Class[]{Integer.TYPE, Integer.TYPE});
        } else {
            this.longhashset = this.getOBCClassNoFail("org.bukkit.craftbukkit.util.LongHashset");
            if (this.longhashset != null) {
                this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"containsKey"}, new Class[]{Integer.TYPE, Integer.TYPE});
            }
        }
        this.longset = this.getOBCClassNoFail("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.longs.LongSet");
        if (this.longhashset != null) {
            this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"contains"}, new Class[]{Long.TYPE});
        }
        this.cps_unloadqueue_isSet = false;
        if (this.longhashset != null) {
            this.cps_unloadqueue = this.getPrivateFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, this.longhashset);
        }
        if (this.cps_unloadqueue == null && this.longset != null) {
            this.cps_unloadqueue = this.getPrivateFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, this.longset);
            this.cps_unloadqueue_isSet = true;
        }
        if (this.cps_unloadqueue == null) {
            this.cps_unloadqueue = this.getFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, Set.class);
            this.cps_unloadqueue_isSet = true;
        }
        if (this.cps_unloadqueue == null) {
            Log.info("Unload queue not found - default to unload all chunks");
        }
        this.nmschunk = this.getNMSClass("net.minecraft.server.Chunk");
        this.nmsc_tileentities = this.getField(this.nmschunk, new String[]{"tileEntities"}, Map.class);
        this.nmsc_inhabitedticks = this.getPrivateFieldNoFail(this.nmschunk, new String[]{"s", "q", "u", "v", "w", "A", "z"}, Long.TYPE);
        if (this.nmsc_inhabitedticks == null) {
            Log.info("inhabitedTicks field not found - inhabited shader not functional");
        }
        this.nmsworldborder = this.getNMSClassNoFail("net.minecraft.server.WorldBorder");
        if (this.nmsworldborder != null) {
            this.worldbordermaxz = this.getMethodNoFail(this.nmsworldborder, new String[]{"f"}, nulltypes);
            if (this.worldbordermaxz == null) {
                this.worldborderminx = this.getMethod(this.nmsworldborder, new String[]{"b"}, nulltypes);
                this.worldborderminz = this.getMethod(this.nmsworldborder, new String[]{"c"}, nulltypes);
                this.worldbordermaxx = this.getMethod(this.nmsworldborder, new String[]{"d"}, nulltypes);
                this.worldbordermaxz = this.getMethod(this.nmsworldborder, new String[]{"e"}, nulltypes);
            } else {
                this.worldborderminx = this.getMethod(this.nmsworldborder, new String[]{"c"}, nulltypes);
                this.worldborderminz = this.getMethod(this.nmsworldborder, new String[]{"d"}, nulltypes);
                this.worldbordermaxx = this.getMethod(this.nmsworldborder, new String[]{"e"}, nulltypes);
            }
        }
        this.nbttagcompound = this.getNMSClass("net.minecraft.server.NBTTagCompound");
        this.nbttagbyte = this.getNMSClass("net.minecraft.server.NBTTagByte");
        this.nbttagshort = this.getNMSClass("net.minecraft.server.NBTTagShort");
        this.nbttagint = this.getNMSClass("net.minecraft.server.NBTTagInt");
        this.nbttaglong = this.getNMSClass("net.minecraft.server.NBTTagLong");
        this.nbttagfloat = this.getNMSClass("net.minecraft.server.NBTTagFloat");
        this.nbttagdouble = this.getNMSClass("net.minecraft.server.NBTTagDouble");
        this.nbttagbytearray = this.getNMSClass("net.minecraft.server.NBTTagByteArray");
        this.nbttagstring = this.getNMSClass("net.minecraft.server.NBTTagString");
        this.nbttagintarray = this.getNMSClass("net.minecraft.server.NBTTagIntArray");
        this.compound_get = this.getMethod(this.nbttagcompound, new String[]{"get"}, new Class[]{String.class});
        this.nbttagbyte_val = this.getPrivateField(this.nbttagbyte, new String[]{"data"}, Byte.TYPE);
        this.nbttagshort_val = this.getPrivateField(this.nbttagshort, new String[]{"data"}, Short.TYPE);
        this.nbttagint_val = this.getPrivateField(this.nbttagint, new String[]{"data"}, Integer.TYPE);
        this.nbttaglong_val = this.getPrivateField(this.nbttaglong, new String[]{"data"}, Long.TYPE);
        this.nbttagfloat_val = this.getPrivateField(this.nbttagfloat, new String[]{"data"}, Float.TYPE);
        this.nbttagdouble_val = this.getPrivateField(this.nbttagdouble, new String[]{"data"}, Double.TYPE);
        this.nbttagbytearray_val = this.getPrivateField(this.nbttagbytearray, new String[]{"data"}, byte[].class);
        this.nbttagstring_val = this.getPrivateField(this.nbttagstring, new String[]{"data"}, String.class);
        this.nbttagintarray_val = this.getPrivateField(this.nbttagintarray, new String[]{"data"}, int[].class);
        this.nms_tileentity = this.getNMSClass("net.minecraft.server.TileEntity");
        this.nmst_readnbt = this.getMethod(this.nms_tileentity, new String[]{"b", "save"}, new Class[]{this.nbttagcompound});
        this.nmst_getposition = this.getMethodNoFail(this.nms_tileentity, new String[]{"getPosition"}, new Class[0]);
        if (this.nmst_getposition == null) {
            this.nmst_x = this.getField(this.nms_tileentity, new String[]{"x"}, Integer.TYPE);
            this.nmst_y = this.getField(this.nms_tileentity, new String[]{"y"}, Integer.TYPE);
            this.nmst_z = this.getField(this.nms_tileentity, new String[]{"z"}, Integer.TYPE);
        } else {
            this.nms_blockposition = this.getNMSClass("net.minecraft.server.BlockPosition");
            this.nmsbp_getx = this.getMethod(this.nms_blockposition, new String[]{"getX"}, new Class[0]);
            this.nmsbp_gety = this.getMethod(this.nms_blockposition, new String[]{"getY"}, new Class[0]);
            this.nmsbp_getz = this.getMethod(this.nms_blockposition, new String[]{"getZ"}, new Class[0]);
        }
    }

    @Override
    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        w.unloadChunk(cx, cz, false, false);
    }

    private String stripBlockString(String bname) {
        int idx = bname.indexOf(123);
        if (idx >= 0) {
            bname = bname.substring(idx + 1);
        }
        if ((idx = bname.indexOf(125)) >= 0) {
            bname = bname.substring(0, idx);
        }
        return bname;
    }

    @Override
    public String[] getBlockNames() {
        try {
            String[] names = new String[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                for (int i = 0; i < names.length; ++i) {
                    if (byid[i] == null) continue;
                    names[i] = this.stripBlockString(byid[i].toString());
                }
            } else {
                for (int i = 0; i < names.length; ++i) {
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null) continue;
                    names[i] = this.stripBlockString(blk.toString());
                }
            }
            return names;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new String[0];
    }

    @Override
    public String[] getBiomeNames() {
        Object[] biomelist = this.getBiomeBaseList();
        String[] names = new String[biomelist.length];
        for (int i = 0; i < biomelist.length; ++i) {
            Object bb = biomelist[i];
            if (bb == null) continue;
            names[i] = this.getBiomeBaseIDString(bb);
        }
        return names;
    }

    protected boolean isBlockMaterialNeeded() {
        return true;
    }

    @Override
    public BukkitMaterial[] getMaterialList() {
        try {
            BukkitMaterial[] map = new BukkitMaterial[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                for (int i = 0; i < map.length; ++i) {
                    Object mat;
                    if (byid[i] == null || (mat = this.material.get(byid[i])) == null) continue;
                    Boolean solid = (Boolean)this.material_issolid.invoke(mat, new Object[0]);
                    Boolean liquid = (Boolean)this.material_isliquid.invoke(mat, new Object[0]);
                    map[i] = new BukkitMaterial(mat.toString(), solid, liquid);
                }
            } else if (this.blockbyidfunc != null) {
                ArrayList mats = new ArrayList();
                for (int i = 0; i < map.length; ++i) {
                    Object mat;
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null || (mat = this.material.get(blk)) == null) continue;
                    Boolean solid = (Boolean)this.material_issolid.invoke(mat, new Object[0]);
                    Boolean liquid = (Boolean)this.material_isliquid.invoke(mat, new Object[0]);
                    map[i] = new BukkitMaterial(mat.toString(), solid, liquid);
                }
            }
            return map;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new BukkitMaterial[0];
    }

    @Override
    public Polygon getWorldBorder(World world) {
        Polygon p = null;
        if (this.getworldborder == null || world == null) {
            return null;
        }
        Object cw = this.getNMSWorld(world);
        if (cw == null) {
            return null;
        }
        Object wb = this.callMethod(cw, this.getworldborder, nullargs, null);
        if (wb != null) {
            double minx = (Double)this.callMethod(wb, this.worldborderminx, nullargs, Double.MIN_VALUE);
            double minz = (Double)this.callMethod(wb, this.worldborderminz, nullargs, Double.MIN_VALUE);
            double maxx = (Double)this.callMethod(wb, this.worldbordermaxx, nullargs, Double.MAX_VALUE);
            double maxz = (Double)this.callMethod(wb, this.worldbordermaxz, nullargs, Double.MAX_VALUE);
            if (maxx < 1.0E7) {
                p = new Polygon();
                p.addVertex(minx, minz);
                p.addVertex(minx, maxz);
                p.addVertex(maxx, maxz);
                p.addVertex(maxx, minz);
            }
        }
        return p;
    }

    @Override
    public Object[] getBiomeBaseList() {
        if (this.getbiomebyid != null || this.getbiomefunc != null) {
            if (this.biomelist == null) {
                this.biomelist = new Object[1024];
                for (int i = 0; i < 1024; ++i) {
                    try {
                        if (this.getbiomefunc != null) {
                            this.biomelist[i] = this.getbiomefunc.invoke((Object)this.biomebase, i, null);
                            continue;
                        }
                        this.biomelist[i] = this.getbiomebyid.invoke((Object)this.biomebase, i);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
            return this.biomelist;
        }
        return super.getBiomeBaseList();
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        if (this.getidbybiome != null) {
            try {
                return (Integer)this.getidbybiome.invoke((Object)this.biomebase, bb);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return super.getBiomeBaseID(bb);
    }

    @Override
    public boolean isUnloadChunkBroken() {
        return this.isBadUnload;
    }

    @Override
    public String getStateStringByCombinedId(int blkid, int meta) {
        int id = blkid | meta << 12;
        if (this.getbycombinedid != null) {
            try {
                String nm;
                int off1;
                Object iblockdata = this.getbycombinedid.invoke(this.nmsblock, id);
                if (iblockdata != null && (off1 = (nm = iblockdata.toString()).indexOf(91)) >= 0) {
                    int off2 = nm.indexOf(93);
                    return nm.substring(off1 + 1, off2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return "meta=" + meta;
    }
}

