/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.lang.reflect.Constructor;
import org.bukkit.Bukkit;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitVersionHelper;

public class Helper {
    private static BukkitVersionHelper loadVersionHelper(String classname) {
        try {
            Class<?> c = Class.forName(classname);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            return (BukkitVersionHelper)cons.newInstance(new Object[0]);
        }
        catch (Exception x) {
            Log.severe("Error loading " + classname, x);
            return null;
        }
    }

    public static final BukkitVersionHelper getHelper() {
        if (BukkitVersionHelper.helper == null) {
            String v = Bukkit.getServer().getVersion();
            Log.info("version=" + v);
            if (v.contains("MCPC")) {
                Log.severe("*********************************************************************************");
                Log.severe("* MCPC-Plus is no longer supported via the Bukkit version of Dynmap.            *");
                Log.severe("* Install the appropriate Forge version of Dynmap.                              *");
                Log.severe("* Add the DynmapCBBridge plugin to enable support for Dynmap-compatible plugins *");
                Log.severe("*********************************************************************************");
            } else if (v.contains("BukkitForge")) {
                Log.severe("*********************************************************************************");
                Log.severe("* BukkitForge is not supported via the Bukkit version of Dynmap.                *");
                Log.severe("* Install the appropriate Forge version of Dynmap.                              *");
                Log.severe("* Add the DynmapCBBridge plugin to enable support for Dynmap-compatible plugins *");
                Log.severe("*********************************************************************************");
            } else if (Bukkit.getServer().getClass().getName().contains("GlowServer")) {
                Log.info("Loading Glowstone support");
                BukkitVersionHelper.helper = Helper.loadVersionHelper("org.dynmap.bukkit.helper.BukkitVersionHelperGlowstone");
            } else {
                BukkitVersionHelper.helper = v.contains("(MC: 1.21.4") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v121_4.BukkitVersionHelperSpigot121_4") : (v.contains("(MC: 1.21.2") || v.contains("(MC: 1.21.3") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v121_3.BukkitVersionHelperSpigot121_3") : (v.contains("(MC: 1.21)") || v.contains("(MC: 1.21.1)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v121.BukkitVersionHelperSpigot121") : (v.contains("(MC: 1.20)") || v.contains("(MC: 1.20.1)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v120.BukkitVersionHelperSpigot120") : (v.contains("(MC: 1.20.2)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v120_2.BukkitVersionHelperSpigot120_2") : (v.contains("(MC: 1.20.3)") || v.contains("(MC: 1.20.4)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v120_4.BukkitVersionHelperSpigot120_4") : (v.contains("(MC: 1.20.") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v120_5.BukkitVersionHelperSpigot120_5") : (v.contains("(MC: 1.19)") || v.contains("(MC: 1.19.1)") || v.contains("(MC: 1.19.2)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v119.BukkitVersionHelperSpigot119") : (v.contains("(MC: 1.19.3)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v119_3.BukkitVersionHelperSpigot119_3") : (v.contains("(MC: 1.19.") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v119_4.BukkitVersionHelperSpigot119_4") : (v.contains("(MC: 1.18)") || v.contains("(MC: 1.18.1)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v118.BukkitVersionHelperSpigot118") : (v.contains("(MC: 1.18") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v118_2.BukkitVersionHelperSpigot118_2") : (v.contains("(MC: 1.17") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v117.BukkitVersionHelperSpigot117") : (v.contains("(MC: 1.16.1") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v116.BukkitVersionHelperSpigot116") : (v.contains("(MC: 1.16.2)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v116_2.BukkitVersionHelperSpigot116_2") : (v.contains("(MC: 1.16.3)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v116_3.BukkitVersionHelperSpigot116_3") : (v.contains("(MC: 1.16.") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v116_4.BukkitVersionHelperSpigot116_4") : (v.contains("(MC: 1.16") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v116.BukkitVersionHelperSpigot116") : (v.contains("(MC: 1.15)") || v.contains("(MC: 1.15.") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v115.BukkitVersionHelperSpigot115") : (v.contains("(MC: 1.14)") || v.contains("(MC: 1.14.1)") || v.contains("(MC: 1.14.2)") || v.contains("(MC: 1.14.3)") || v.contains("(MC: 1.14.4)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v114_1.BukkitVersionHelperSpigot114_1") : (v.contains("(MC: 1.13.2)") ? Helper.loadVersionHelper("org.dynmap.bukkit.helper.v113_2.BukkitVersionHelperSpigot113_2") : Helper.loadVersionHelper("org.dynmap.bukkit.helper.BukkitVersionHelperCB")))))))))))))))))))));
            }
        }
        return BukkitVersionHelper.helper;
    }
}

