import {
  initializeNotifications,
  parameterNotifications,
} from "../../assets/js/customNotification.js";
import {
  getDirectionForPlayer,
  leaveTable,
  tableNotFound,
  joinTable,
  displayUsers
} from "../../assets/js/customTable.js";
import { redirectToLoginWithoutBearer } from "../../assets/js/customAuthFlow.js";
import { displayBoard } from "../../assets/js/customGame.js";

window.addEventListener("load", load);

// Font awesome icons not responsive

async function load() {
  // Notifications
  initializeNotifications();
  parameterNotifications();

  redirectToLoginWithoutBearer();

  // URLSearchParams
  let urlSearchParams = new URLSearchParams(location.search);
  let tableId = urlSearchParams.get("tableId");

  if (!tableId || tableId.length == 0) {
    tableNotFound("empty");
  } else {
    await joinTable(tableId);
    let direction = await getDirectionForPlayer(tableId);
    await displayBoard(direction)
    await displayUsers(tableId);
    let board = document.getElementById("board")
    board.classList.remove("md:max-h-[55%]")
    board.classList.add("grow")
  }

  let leaveTableButton = document.getElementById("leaveTableButton");

  leaveTableButton.addEventListener("click", () => leaveTable(tableId));
}
