import { customFetch } from "./customFetch.js";
import { createNotification } from "./customNotification.js";
import { setBearer, hasBearer, removeBearer } from "./customBearer.js";

async function login(username, password) {
  let body = {
    email: `${username}`,
    password: `${password}`,
  };

  let response = await customFetch("api/Authentication/token", "POST", body);
  
  if (!response.ok) {
    createNotification("Invalid credentials");
  } else {
    let bearer = response.data.token;
    setBearer(bearer);
    setUserId(response.data.user.id);
    window.location.href = "/Frontend/src/auth/lobby.html"
  }
}

async function register(email, username, password) {
  let body = {
    email: `${email}`,
    password: `${password}`,
    wariorName: `${username}`
  };

  let response = await customFetch("api/Authentication/register", "POST", body);
  if (!response.ok) {
    refillRegisterForm(email, username, password, password);
    createNotification(`${response.message}`)
  } else {
    toggleLoginForm();
    refillLoginForm(email);
  }
}

function hasEmptyFields(...values) {
  let empty = false;
  values.forEach((value) => {
    if (!value || value.trim().length == 0) {
      empty = true;
    }
  });
  return empty;
};

function refillRegisterForm(email = "", username = "", password = "", passwordConfirmation = "") {
  let registerEmailInput = document.getElementById("registerEmail");
  registerEmailInput.value = email;
  let registerUsernameInput = document.getElementById("registerUsername");
  registerUsernameInput.value = username;
  let registerPasswordInput = document.getElementById("registerPassword");
  registerPasswordInput.value = password;
  let registerPasswordConfirmationInput = document.getElementById("registerPasswordConfirmation");
  registerPasswordConfirmationInput.value = passwordConfirmation;
};

function refillLoginForm(email = "", password = "") {
  let loginEmailInput = document.getElementById("loginEmail");
  loginEmailInput.value = email;
  let loginPasswordInput = document.getElementById("loginPassword");
  loginPasswordInput.value = password;
};

function logout(){
  removeBearer()
  removeUserId();
  window.location.href = "/Frontend/src/index.html?notification=Logged out succesfully";
}


function redirectToLoginWithoutBearer(){
  if (!hasBearer()) {
      window.location.href = "/Frontend/src/index.html?notification=Login required";
  }
}

function setUserId(value){
  sessionStorage.setItem("userId", value);
}

function getUserId(){
  return sessionStorage.getItem("userId");
}

function removeUserId(){
  sessionStorage.removeItem("userId");
}

function toggleRegisterForm() {
  let loginForm = document.getElementById("loginForm");
  let registerForm = document.getElementById("registerForm");
  let signInButton = document.getElementById("signInButton");
  let registerButton = document.getElementById("registerButton");

  loginForm.classList.add("hidden");
  registerForm.classList.remove("hidden");
  signInButton.classList.remove("underline");
  registerButton.classList.add("underline");
}

function toggleLoginForm() {
  let loginForm = document.getElementById("loginForm");
  let registerForm = document.getElementById("registerForm");
  let signInButton = document.getElementById("signInButton");
  let registerButton = document.getElementById("registerButton");

  loginForm.classList.remove("hidden");
  registerForm.classList.add("hidden");
  signInButton.classList.add("underline");
  registerButton.classList.remove("underline");
}

export {login, logout, register, hasEmptyFields, refillRegisterForm, redirectToLoginWithoutBearer, getUserId, toggleLoginForm, toggleRegisterForm}