﻿using System.Drawing;
using Onitama.Core.GameAggregate.Contracts;
using Onitama.Core.MoveCardAggregate.Contracts;
using Onitama.Core.PlayerAggregate.Contracts;
using Onitama.Core.PlayMatAggregate;
using Onitama.Core.TableAggregate.Contracts;

namespace Onitama.Core.GameAggregate;

internal class GameFactory : IGameFactory
{
    private readonly IMoveCardRepository _moveCardRepository;

    public GameFactory(IMoveCardRepository moveCardRepository)
    {
        _moveCardRepository = moveCardRepository;
    }

    public IGame CreateNewForTable(ITable table)
    {
        Random random = new Random();
        if (table.SeatedPlayers.Count != table.Preferences.NumberOfPlayers)
        {
            throw new InvalidOperationException("Table doesn't have enough players");
        }

        IList<Color> playerColors = new List<Color>();
        foreach (IPlayer player in table.SeatedPlayers)
        {
            playerColors.Add(player.Color);
        }
        
        IList<IMoveCard> allCards = _moveCardRepository.LoadSet(MoveCardSet.Original, playerColors.ToArray()).ToList();
        IMoveCard extraCard = allCards[random.Next(0, allCards.Count - 1)];
        allCards.Remove(extraCard);
        
        foreach (IPlayer player in table.SeatedPlayers)
        {
            // Pick 2 random cards out of the list
            for (int i = 0; i < 2; i++)
            {
                IMoveCard card = allCards[random.Next(0, allCards.Count - 1)];
                player.MoveCards.Add(card);
                allCards.Remove(card);
            }
        }
        
        return new Game(Guid.NewGuid(), new PlayMat(table.Preferences.PlayerMatSize), table.SeatedPlayers.ToArray(), extraCard);
    }
}