package be.pxl.opgave;
/* naam: */

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class Wedstrijd extends Toernooi implements DatumVergelijkbaar {
    private LocalDateTime wedstrijdDatum;
    private Team team1;
    private Team team2;
    private Scheidsrechter scheidsrechter;
    private int scoreTeam1;
    private int scoreTeam2;

    @Override
    public long berekenAantalMinutenNa(LocalDateTime localDateTime) {
        return 0;
    }

    public Wedstrijd(Team team1, Team team2, Scheidsrechter scheidsrechter, int dag, int maand, int jaar, int uur, int minuut) {
        this.team1 = team1;
        this.team2 = team2;
        this.scheidsrechter = scheidsrechter;
        wedstrijdDatum = LocalDateTime.of(jaar, maand, dag, uur, minuut);
    }

    public boolean spelerIdKomtVoor(String spelerId) {
        if (team1 != null && team2 != null) {
            if(this.team1.spelerIdKomtVoor(spelerId)) {
                if (this.team2.spelerIdKomtVoor(spelerId)) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public LocalDateTime getWedstrijdDatum() {
        return this.wedstrijdDatum;
    }

    public void setScore(int scoreTeam1, int scoreTeam2) {
        this.scoreTeam1 = scoreTeam1;
        this.scoreTeam2 = scoreTeam2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TEAM 1\n");
        for (Speler speler : team1.getSpelers()) {
            stringBuilder.append(speler);
        }
        stringBuilder.append("TEAM 2\n");
        for (Speler speler : team2.getSpelers()) {
            stringBuilder.append(speler);
        }
        stringBuilder.append(wedstrijdDatum + "\n");
        stringBuilder.append("SCHEIDSRECHTER " + scheidsrechter + "\n");
        stringBuilder.append("SCORE " + scoreTeam1 + " " + scoreTeam2);
        return stringBuilder.toString();
    }
}
