package be.pxl.opgave;
/* naam: */

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class Team {
    private Sport sport;
    private Speler[] spelers;

    public Team(Sport sport) {
        this.sport = sport;
        this.spelers = new Speler[this.sport.getAantalSpelers()];
    }

    public Speler[] getSpelers() {
        return spelers;
    }

    public void voegSpelerToe(Speler speler) {
        if (speler.getSport().equals(sport)) {
            if (!spelerKomtVoor(speler)) {
                this.spelers[vindVrijePositie()] = speler;
            } else {
                System.out.println("Foutieve ingave");
            }
        } else {
            System.out.println("Foutieve ingave");
        }
    }

    private boolean spelerKomtVoor(Speler speler) {
        for (Speler value : this.spelers) {
            if (value != null) {
                if (value.equals(speler)) {
                    return true;
                }
            }
        }
        return false;
    }

    private int vindVrijePositie() {
        for (int i = 0; i < this.spelers.length; i++) {
            if (this.spelers[i] == null) {
                return i;
            }
        }
        return -1;
    }

    public boolean spelerIdKomtVoor(String spelerId) {
        for (Speler value : this.spelers) {
            if (value.getId().equals(spelerId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (vindVrijePositie() > 0) {
            return "Onvolledig team";
        } else {
            StringBuilder spelerString = new StringBuilder();
            for(Speler speler : this.spelers) {
                spelerString.append("[%s] %s (%s)\n".formatted(speler.getId(), speler.getNaam(), speler.getSport()));
            }
            return spelerString.toString();
        }
    }
}