package be.pxl.cargo.api;

import be.pxl.cargo.service.ShipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/shipments")
public class ShipmentController {

    private final ShipmentService shipmentService;

    @Autowired
    public ShipmentController(ShipmentService shipmentService) {
        this.shipmentService = shipmentService;
    }

    @PutMapping("/{shipmentId}/cargo/{cargoCode}")
    @ResponseStatus(HttpStatus.ACCEPTED)
    public void addCargoToShipment(@PathVariable Long shipmentId, @PathVariable String cargoCode) {
        shipmentService.addCargoToShipment(shipmentId, cargoCode);
    }

    @PutMapping("/{shipmentId}/arrive")
    @ResponseStatus(HttpStatus.ACCEPTED)
    public void setArrivedStatusOfShipment(@PathVariable Long shipmentId) {
        shipmentService.markShipmentAsArrived(shipmentId);
    }
}
