package be.pxl.cargo.domain;

import be.pxl.cargo.exception.ShipmentException;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import static org.junit.jupiter.api.Assertions.*;

@SpringBootTest
public class ShipmentTest {
    @Test
    public void testForCargoAtWrongLocation() {
        Shipment shipment = new Shipment(Location.AIRPORT_X, Location.WAREHOUSE_A, 100);
        Cargo dummyCargo = new Cargo("TEST", 200, Location.CITY_B, Location.WAREHOUSE_A);
        assertThrows(ShipmentException.class, () -> shipment.addCargo(dummyCargo), "Cargo at wrong location.");
    }

    @Test
    public void testIfCanBeAddedToShipmentWhenCapacityNotReached() {
        Shipment shipment = new Shipment(Location.AIRPORT_X, Location.WAREHOUSE_A, 400);
        Cargo dummyCargo = new Cargo("TEST", 200, Location.AIRPORT_X, Location.WAREHOUSE_A);
        shipment.addCargo(dummyCargo);

        assertTrue(shipment.getCargoList().contains(dummyCargo));
        assertEquals(CargoStatus.MOVING, dummyCargo.getCargoStatus());
    }

    @Test
    public void testIfShipmentExceptionIsThrownWhenCapacityReached() {
        Shipment shipment = new Shipment(Location.AIRPORT_X, Location.WAREHOUSE_A, 100);
        Cargo dummyCargo = new Cargo("TEST", 200, Location.AIRPORT_X, Location.WAREHOUSE_A);

        assertThrows(ShipmentException.class, () -> shipment.addCargo(dummyCargo), "Shipment capacity exceeded.");
    }
}
