package be.pxl.cargo.service;

import be.pxl.cargo.api.request.CreateCargoRequest;
import be.pxl.cargo.api.response.CargoStatistics;
import be.pxl.cargo.domain.Cargo;
import be.pxl.cargo.domain.CargoStatus;
import be.pxl.cargo.domain.Location;
import be.pxl.cargo.exception.InvalidCodeException;
import be.pxl.cargo.repository.CargoRepository;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.antlr.v4.runtime.tree.xpath.XPath.findAll;

@Service
public class CargoService {

    private final CargoRepository cargoRepository;

    public CargoService(CargoRepository cargoRepository) {
        this.cargoRepository = cargoRepository;
    }

    public void createCargo(CreateCargoRequest createCargoRequest) {
        // TODO controleer dat de code van de nieuwe cargo uniek is.
        Cargo existingCargo = cargoRepository.findCargoByCode(createCargoRequest.code());
        if (existingCargo != null) {
            throw new InvalidCodeException("Code is already in use");
        }
        Cargo cargo = new Cargo(createCargoRequest.code(), createCargoRequest.weight(), createCargoRequest.origin(), createCargoRequest.destination());
        cargoRepository.save(cargo);
    }

    public CargoStatistics getCargoStatistics() {
        CargoStatistics cargoStatistics = new CargoStatistics();
        // TODO: Bereken de volgende waarden. Maak hierbij zoveel mogelijk gebruik van de Stream API.
        // TODO 1: Tel het aantal cargo's per cargostatus.
        //  Zet deze resultaten in een map met de cargostatus als key en het aantal cargo's als value.
        //  Vermijd dubbele code!
        List<Cargo> cargoList = cargoRepository.findAll();

        Long cargosDeliveredCount = cargoList.stream().filter(cargo -> cargo.getCargoStatus() == CargoStatus.DELIVERED).count();
        Long cargosCreatedCount = cargoList.stream().filter(cargo -> cargo.getCargoStatus() == CargoStatus.CREATED).count();
        Long cargosAtTransitPointCount = cargoList.stream().filter(cargo -> cargo.getCargoStatus() == CargoStatus.AT_TRANSIT_POINT).count();
        Long cargosMovingCount = cargoList.stream().filter(cargo -> cargo.getCargoStatus() == CargoStatus.MOVING).count();
        cargoStatistics.setStatusCount(Map.of(CargoStatus.DELIVERED, cargosDeliveredCount));
        cargoStatistics.setStatusCount(Map.of(CargoStatus.CREATED, cargosCreatedCount));
        cargoStatistics.setStatusCount(Map.of(CargoStatus.AT_TRANSIT_POINT, cargosAtTransitPointCount));
        cargoStatistics.setStatusCount(Map.of(CargoStatus.MOVING, cargosMovingCount));

        // TODO 2: Welke cargo heeft het hoogste gewicht?
        //  Geef van de unieke code van deze cargo.


        // TODO 3: Wat is het gemiddelde gewicht van alle cargo's?


        // TODO 4: Hoeveel cargo's staan momenteel op locatie WAREHOUSE_A?
        cargoStatistics.setCountCargosAtWarehouseA(cargoList.stream().filter(cargo ->
                cargo.getCurrentLocation() == Location.WAREHOUSE_A).count());

        // TODO 5: Wat is het totale gewicht van de cargo's op locatie CITY_B met status DELIVERED?

        return cargoStatistics;
    }
}
